package ru.yandex.autotests.directapi.keywordsresearch.deduplicate;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.keywordsresearch.DeduplicateResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.keywordsresearch.KeywordsResearchFeatures;
import ru.yandex.autotests.directapi.keywordsresearch.KeywordsResearchLogins;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.DeduplicateRequestItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.DeduplicateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(KeywordsResearchFeatures.CHECK_LOGIN_POSSIBLE)
@Description("Тест на возможность доступа к ручке KeywordsResearch.deduplicate с указанием/без указания client-login")
@RunWith(Parameterized.class)
public class CanLoginAgencyClientPositiveTest {

    @Parameterized.Parameter
    public String login;

    @Parameterized.Parameter(1)
    public String clientLogin;

    @Parameterized.Parameters(name = "operator: {0}, client: {1}")
    public static List<Object[]> parameters() {
        return Arrays.asList(
                new Object[]{KeywordsResearchLogins.CLIENT, null},
                new Object[]{KeywordsResearchLogins.AGENCY, null},
                new Object[]{KeywordsResearchLogins.AGENCY, KeywordsResearchLogins.SUBCLIENT}
        );
    }


    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Test
    public void loginPossibleAsClientTest() {
        DeduplicateRequestMap requestMap = prepareRequest();
        DeduplicateResponse response = api
                .as(login)
                .userSteps
                .keywordsResearchSteps()
                .keywordsResearchDeduplicateRawResponse(clientLogin, requestMap);
        assertThat("ответ из сервиса получен", response.getAdd(),
                hasSize(1));
    }

    private DeduplicateRequestMap prepareRequest() {
        return new DeduplicateRequestMap()
                .withKeywords(new DeduplicateRequestItemMap().withKeyword("ключевая фраза"));
    }
}
