package ru.yandex.autotests.directapi.keywordsresearch.hassearchvolume;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.keywordsresearch.KeywordsResearchFeatures;
import ru.yandex.autotests.directapi.keywordsresearch.KeywordsResearchLogins;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(KeywordsResearchFeatures.CHECK_LOGIN_POSSIBLE)
@Description("Тест на возможность доступа к ручке KeywordsResearch.hasSearchVolume с указанием/без указания client-login")
@RunWith(Parameterized.class)
public class CanLoginAgencyClientPositiveTest {
    private static final List<String> keywords = Arrays.asList("носки", "брюки");

    @Parameterized.Parameter
    public String login;

    @Parameterized.Parameter(1)
    public String clientLogin;

    @Parameterized.Parameters(name = "operator: {0}, client: {1}")
    public static List<Object[]> parameters() {
        return Arrays.asList(
                new Object[]{KeywordsResearchLogins.CLIENT, null},
                new Object[]{KeywordsResearchLogins.AGENCY, null},
                new Object[]{KeywordsResearchLogins.AGENCY, KeywordsResearchLogins.SUBCLIENT}
        );
    }


    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Test
    public void loginPossibleAsClientTest() {
        HasSearchVolumeRequestMap requestMap = prepareRequest();
        HasSearchVolumeResponse response = api
                .as(login)
                .userSteps
                .keywordsResearchSteps()
                .keywordsResearchHasSearchVolumeRawResponse(clientLogin, requestMap);
        assertThat("ответ из сервиса получен", response.getHasSearchVolumeResults(),
                hasSize(keywords.size()));
    }

    private HasSearchVolumeRequestMap prepareRequest() {
        return new HasSearchVolumeRequestMap()
                .withSelectionCriteria(new HasSearchVolumeSelectionCriteriaMap()
                        .withKeywords(keywords)
                        .withRegionIds(0L))
                .withFieldNames(HasSearchVolumeFieldEnum.KEYWORD, HasSearchVolumeFieldEnum.ALL_DEVICES);
    }
}
