package ru.yandex.autotests.directapi.keywordsresearch.hassearchvolume;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywordsresearch.KeywordsResearchFeatures;
import ru.yandex.autotests.directapi.keywordsresearch.KeywordsResearchLogins;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.ALL_DEVICES;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.DESKTOPS;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.KEYWORD;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.MOBILE_PHONES;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.TABLETS;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(KeywordsResearchFeatures.HAS_SEARCH_VOLUME)
@Description("Позитивные запросы с минус-словами")
@RunWith(Parameterized.class)
public class HasSearchVolumeKeywordValidationPositiveTest {

    private static final int THREE_SECONDS = 3 * 1000;

    private static final String CLIENT = KeywordsResearchLogins.CLIENT2;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String keyword;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        Object[][] data = new Object[][] {
                {"Ключевое с минус-словом", "остекление -балкон"},
                {"Ключевое с минусом из стоп-слова", "мультики -все"},
                {"Ключевое с минусом из стоп-слова с символом 'ё'", "хаски -всё"},
                {"Ключевое с несколькими минус-словами", "остекление -балкон -окно -витраж"},
                {"Ключевое с одинаковыми минус-словами", "ремонт -бесплатный -бесплатный"},
                {"Ключевые слова с минус-словом", "остекление лоджий -срочное"},
                {"Минус-слово с фиксацией словоформы", "остекление -!балконов"},
                {"Ключевое с минус-словом на белорусском языке", "аплата -наяўнымі"},
                {"Минус-слово является плюс-словом в фиксированной форме", "доставка пицца -!пицца"},
                {"7 ключевых слов + 1 стоп-слово", "пицца отель в москва гостиница поезд самолет такси"},
                {"7 ключевых слов + 1 минус-слово", "пицца отель москва гостиница поезд самолет такси -теплоход"},
                {"Ключевое слово с точкой", "пицца 15.16"},
                {"Ключевое слово с минус-словом с точкой", "пицца -15.16"}
        };
        return Arrays.asList(data);
    }

    @Before
    public void delayRequest() throws InterruptedException {
        // Разрешено не более 20 запросов за окно в 60 секунд
        Thread.sleep(THREE_SECONDS);
    }

    @Test
    public void checkHasSearchVolume() {
        HasSearchVolumeRequestMap request = new HasSearchVolumeRequestMap()
                .withSelectionCriteria(new HasSearchVolumeSelectionCriteriaMap()
                        .withKeywords(keyword)
                        .withRegionIds(0L))
                .withFieldNames(KEYWORD, DESKTOPS, MOBILE_PHONES, TABLETS, ALL_DEVICES);

        HasSearchVolumeResponse response =
                api.userSteps.keywordsResearchSteps().keywordsResearchHasSearchVolumeRawResponse(CLIENT, request);

        assertThat("Получен ответ без ошибок", response.getHasSearchVolumeResults(),
                hasSize(1));
    }
}
