package ru.yandex.autotests.directapi.keywordsresearch.hassearchvolume;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeItem;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.keywordsresearch.KeywordsResearchFeatures;
import ru.yandex.autotests.directapi.keywordsresearch.KeywordsResearchLogins;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.ALL_DEVICES;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.DESKTOPS;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.KEYWORD;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.MOBILE_PHONES;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.TABLETS;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(KeywordsResearchFeatures.HAS_SEARCH_VOLUME)
@Description("Тест на общую корректность работы сервиса")
public class HasSearchVolumeSmokeTest {
    private static final String CLIENT = KeywordsResearchLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @Test
    public void smokeTest() {
        HasSearchVolumeRequestMap request = new HasSearchVolumeRequestMap()
                .withSelectionCriteria(new HasSearchVolumeSelectionCriteriaMap()
                        .withKeywords("носки", "брюки")
                        .withRegionIds(0L))
                .withFieldNames(KEYWORD, ALL_DEVICES);
        HasSearchVolumeResponse response =
                api.userSteps.keywordsResearchSteps().keywordsResearchHasSearchVolumeRawResponse(CLIENT, request);
        assertThat("ответ из сервиса получен", response.getHasSearchVolumeResults(),
                hasSize(2));
    }

    @Test
    public void allFourDevicesListedTest() {
        HasSearchVolumeRequestMap request = new HasSearchVolumeRequestMap()
                .withSelectionCriteria(new HasSearchVolumeSelectionCriteriaMap()
                        .withKeywords("носки", "брюки")
                        .withRegionIds(0L))
                .withFieldNames(KEYWORD, DESKTOPS, MOBILE_PHONES, TABLETS, ALL_DEVICES);

        HasSearchVolumeResponse response =
                api.userSteps.keywordsResearchSteps().keywordsResearchHasSearchVolumeRawResponse(CLIENT, request);

        HasSearchVolumeItem item = response.getHasSearchVolumeResults().get(0);
        int deviceCount = (item.getAllDevices() != null ? 1 : 0)
                + (item.getDesktops() != null ? 1 : 0)
                + (item.getMobilePhones() != null ? 1 : 0)
                + (item.getTablets() != null ? 1 : 0);
        assertThat("в ответе содержатся четыре флага", deviceCount, equalTo(4));
    }

    @Test
    public void correctKeywordsTest() {
        HasSearchVolumeRequestMap request = new HasSearchVolumeRequestMap()
                .withSelectionCriteria(new HasSearchVolumeSelectionCriteriaMap()
                        .withKeywords(
                                "муфельная -печь",
                                "Нью-Йорк",
                                "\"жк барская усадьба\"")
                        .withRegionIds(0L))
                .withFieldNames(KEYWORD, DESKTOPS, MOBILE_PHONES, TABLETS, ALL_DEVICES);

        HasSearchVolumeResponse response =
                api.userSteps.keywordsResearchSteps().keywordsResearchHasSearchVolumeRawResponse(CLIENT, request);
        assertThat("все ответы получены", response.getHasSearchVolumeResults().size(), equalTo(3));
    }

    @Test
    public void keywordsWithLeadingSpacesInRequestTest() {
        HasSearchVolumeRequestMap request = new HasSearchVolumeRequestMap()
                .withSelectionCriteria(new HasSearchVolumeSelectionCriteriaMap()
                        .withKeywords(" тмф ")
                        .withRegionIds(0L))
                .withFieldNames(ALL_DEVICES);

        HasSearchVolumeResponse response =
                api.userSteps.keywordsResearchSteps().keywordsResearchHasSearchVolumeRawResponse(CLIENT, request);
        assertThat("все ответы получены", response.getHasSearchVolumeResults().size(), equalTo(1));
    }

}
