package ru.yandex.autotests.directapi.reports;

import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.*;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by onotole on 7/22/16.
 * https://st.yandex-team.ru/TESTIRT-9740
 */
@Aqua.Test
@Description("Проверка ролей в репортах. Негативные сценарии")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class CheckRolesNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"медиапланер - клиент",
                        Logins.AGENCY_IN_2_SHARD, Logins.CLIENT_IN_2_SHARD,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {"менеджер - клиент",
                        Logins.MANAGER_DEFAULT, Logins.CLIENT_FOR_METRICA_MONITORING,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {"менеджер - субклиент с двумя агентствами",
                        Logins.MANAGER_GEO, Logins.SUBCLIENT_WITH_TWO_AG,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
        };
        return Arrays.asList(data);
    }

    @Test
    public void testRole() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                        .withField(FieldEnum.AGE)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(AgeRangeEnum.AGE_18_24.value()),
                                new FilterItemMap()
                                        .withField(FieldEnum.CRITERIA_TYPE)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(FieldEnum.KEYWORD.toString()))
                )
                .withFieldNames(FieldEnum.AGE, FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.TODAY)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        api.as(operator).userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap, client, expectedError);
    }

}
