package ru.yandex.autotests.directapi.reports;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.*;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.*;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 7/22/16.
 * https://st.yandex-team.ru/TESTIRT-9740
 */
@Aqua.Test
@Description("Проверка ролей в репортах. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class CheckRolesTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"менеджер - сервисируемый клиент",
                        ReportsLogins.ROLE_TEST_SERVICING_MANAGER, ReportsLogins.ROLE_TEST_SERVICING_CLIENT},
                {"медиапланер - клиент",
                        Logins.MEDIA, ReportsLogins.ROLE_TEST_SELF_CLIENT},
                {"суперридер - клиент",
                        Logins.SUPER_READER, ReportsLogins.ROLE_TEST_SELF_CLIENT},
                {"вешальщик - клиент",
                        Logins.PLACER, ReportsLogins.ROLE_TEST_SELF_CLIENT},
                {"саппорт - клиент",
                        Logins.SUPPORT, ReportsLogins.ROLE_TEST_SELF_CLIENT},
                {"супер - сервисируемый клиент",
                        Logins.SUPER_LOGIN, ReportsLogins.ROLE_TEST_SERVICING_CLIENT},
                {"супер - клиент",
                        Logins.SUPER_LOGIN, ReportsLogins.ROLE_TEST_SELF_CLIENT},
                {"менеджер - субклиент",
                        ReportsLogins.ROLE_TEST_SUBCLIENT_MANAGER, ReportsLogins.ROLE_TEST_SUBCLIENT_CLIENT},
                {"менеджер - субклиент со свободой",
                        ReportsLogins.ROLE_TEST_FREEDOM_MANAGER, ReportsLogins.ROLE_TEST_FREEDOM_CLIENT},
                {"супер - субклиент с правами редактирования",
                        Logins.SUPER_LOGIN, ReportsLogins.ROLE_TEST_WITH_EDIT_RIGHTS},
                {"супер - субклиент без прав редактирования",
                        Logins.SUPER_LOGIN, ReportsLogins.ROLE_TEST_WITHOUT_EDIT_RIGHTS},
        };
        return Arrays.asList(data);
    }

    @Test
    public void testRole() {
        // пример как искать клиентов на замену со статистикой
        // https://yql.yandex-team.ru/Operations/YAiGN_4RDkzq2QVuYTzW4yIUGI_i8Pqqk2sY8B867bM=
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap())
                .withFieldNames(FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withCustomDates("2020-10-17", "2020-12-17")
                .withPage(new PageMap().withLimit(1L))
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        ReportsData reportsData = api.as(ReportsLogins.SUPER_LOGIN, operator).userSteps.reportsSteps().callReportsXml(reportDefinitionMap, client);
        assertThat("пользователь " + operator + " успешно получил отчет для клиента " + client,
                reportsData.getReportsLines(), not(empty()));

    }

}
