package ru.yandex.autotests.directapi.reports;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.*;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by ginger on 09.03.17.
 */
@Aqua.Test
@Description("Проверка несовместимости полей AudienceTargetId, DynamicTextAdTargetId, SmartBannerFilterId, Keyword, CriteriaType и CriterionType")
@Issue("https://st.yandex-team.ru/DIRECT-61262")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class FilterByCriteriaFieldsNegativeTest {
    private static final String DEFAULT_VALUE = "123";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(ReportsLogins.SUPER_LOGIN).clientLogin(ReportsLogins.REPORTS_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FieldEnum filterField1;

    @Parameterized.Parameter(1)
    public FieldEnum filterField2;

    @Parameterized.Parameters(name = "{0} + {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {FieldEnum.CRITERIA_TYPE, FieldEnum.AUDIENCE_TARGET_ID},
                {FieldEnum.CRITERIA_TYPE, FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID},
                {FieldEnum.CRITERIA_TYPE, FieldEnum.SMART_BANNER_FILTER_ID},
                {FieldEnum.CRITERIA_TYPE, FieldEnum.KEYWORD},
                {FieldEnum.KEYWORD, FieldEnum.SMART_BANNER_FILTER_ID},
                {FieldEnum.KEYWORD, FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID},
                {FieldEnum.KEYWORD, FieldEnum.AUDIENCE_TARGET_ID},
                {FieldEnum.SMART_BANNER_FILTER_ID, FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID},
                {FieldEnum.SMART_BANNER_FILTER_ID, FieldEnum.AUDIENCE_TARGET_ID},
                {FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID, FieldEnum.AUDIENCE_TARGET_ID},
                {FieldEnum.CRITERION_TYPE, FieldEnum.AUDIENCE_TARGET_ID},
                {FieldEnum.CRITERION_TYPE, FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID},
                {FieldEnum.CRITERION_TYPE, FieldEnum.SMART_BANNER_FILTER_ID},
                {FieldEnum.CRITERION_TYPE, FieldEnum.KEYWORD},
        };
        return Arrays.asList(data);
    }

    @Test
    public void test() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(
                                new FilterItemMap()
                                        .withField(filterField1)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(DEFAULT_VALUE),
                                new FilterItemMap()
                                        .withField(filterField2)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(DEFAULT_VALUE))
                )
                .withFieldNames(FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.TODAY)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap,
                new Api5Error(4001, Api5ErrorDetails.ONLY_ONE_OF_THE_CRITERIA_TYPE));
    }
}
