package ru.yandex.autotests.directapi.reports;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportProcessingMode;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 27.12.16.
 * https://st.yandex-team.ru/TESTIRT-10825
 */
@Aqua.Test
@Description("Проверка, что определенные отчеты создаются всегда в режиме офлайн")
@Issue("https://st.yandex-team.ru/DIRECT-61621")
@Features(ReportsFeatures.FORCE_OFFLINE)
public class ForceOfflineWithExplicitOnlineModeNegativeTest {

    private final static Long CAMPAIGN_ID = 7446973L;
    private final static List<Long> ELEVEN_CAMPAIGN_IDS = Arrays.asList(
            7446885L, 7446965L, 7446967L, 7446969L, 7446970L,
            7446972L, 7446975L, 7446976L, 7446977L, 7446979L,
            CAMPAIGN_ID
    );
    private final static DateTime DATE_TO = DateTime.now();
    private final static DateTime DATE_FROM = DATE_TO.minusDays(7);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_FOR_FORCE_OFFLINE);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    public void checkForceOfflineSearchQueryPerformanceReportWithExplicitOnlineMode() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultSearchQueryReportWithUniqueReportName()
                .withDateRangeType(DateRangeTypeEnum.TODAY)
                .withCampaignIds(CAMPAIGN_ID);
        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                reportDefinitionMap,
                new Api5Error(8312, Api5ErrorDetails.CANT_PROCESS_REPORT_IN_ONLINE_MODE),
                ReportProcessingMode.ONLINE
        );
    }

    @Test
    public void checkForceOfflineCustomReportForAllTimeWithExplicitOnlineMode() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withDateRangeType(DateRangeTypeEnum.ALL_TIME)
                .withCampaignIds(CAMPAIGN_ID);
        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                reportDefinitionMap,
                new Api5Error(8312, Api5ErrorDetails.CANT_PROCESS_REPORT_IN_ONLINE_MODE),
                ReportProcessingMode.ONLINE
        );
    }

    @Test
    public void checkForceOfflineCustomReportForMoreThanSevenDaysWithExplicitOnlineMode() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withCustomDatesAndCampaignIds(DATE_FROM, DATE_TO, CAMPAIGN_ID);
        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                reportDefinitionMap,
                new Api5Error(8312, Api5ErrorDetails.CANT_PROCESS_REPORT_IN_ONLINE_MODE),
                ReportProcessingMode.ONLINE
        );
    }

    @Test
    public void checkForceOfflineCustomReportForMoreThanTenCampaignsWithExplicitOnlineMode() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withDateRangeType(DateRangeTypeEnum.TODAY)
                .withCampaignIds(ELEVEN_CAMPAIGN_IDS.toArray(new Long[ELEVEN_CAMPAIGN_IDS.size()]));
        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                reportDefinitionMap,
                new Api5Error(8312, Api5ErrorDetails.CANT_PROCESS_REPORT_IN_ONLINE_MODE),
                ReportProcessingMode.ONLINE
        );
    }
}
