package ru.yandex.autotests.directapi.reports;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonErrorMatcher;
import ru.yandex.autotests.directapi.apiclient.version5.BaseApiV5Request;
import ru.yandex.autotests.directapi.apiclient.version5.ReportsClient;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportProcessingMode;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by hmepas on 08.06.17
 * https://st.yandex-team.ru/DIRECT-67062
 */

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-60150")
@Description("Проверка валидации JSON по XSD")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class InvalidJsonTest {
    public static final String LOGIN = ReportsLogins.CLIENT_FOR_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static ReportsClient reportsClient;

    @BeforeClass
    public static void initClient() {
        BaseApiV5Request request = new BaseApiV5Request() {
            @Override
            public String getRequestAsString() {
                return (String) parameters;
            }

            @Override
            public ProtocolType getProtocolType() {
                return ProtocolType.JSON;
            }
        };

        DirectTestRunProperties properties = DirectTestRunProperties.getInstance();
        ConnectionConfig connectionConfig = new ConnectionConfig(properties.getDirectAPIHost());
        RequestHeader requestHeader = new RequestHeader(LOGIN);
        reportsClient = new ReportsClient(connectionConfig, requestHeader, request);
    }

    @Test
    @Description("Не правильный тип FieldNames")
    public void testFieldNamesNotArray() {
        String json = "{\n"
                + "    \"params\" : {\n"
                + "        \"SelectionCriteria\" : {\n"
                + "            \"Filter\" : [{\n"
                + "                \"Field\" : \"CampaignId\",\n"
                + "                \"Operator\" : \"EQUALS\",\n"
                + "                \"Values\" : [ 1287989 ]\n"
                + "            }]\n"
                + "        },\n"
                + "        \"FieldNames\" : \"CampaignId\",\n" // ошибка тут
                + "        \"Page\" : { \"Limit\" : 10 },\n"
                + "        \"ReportName\" : \"testReport 20170220-1\",\n"
                + "        \"ReportType\" : \"CUSTOM_REPORT\",\n"
                + "        \"DateRangeType\" : \"LAST_WEEK\",\n"
                + "        \"Format\" : \"TSV\",\n"
                + "        \"IncludeVAT\" : \"YES\",\n"
                + "        \"IncludeDiscount\" : \"YES\"\n"
                + "    }\n"
                + "}";

        Api5JsonError actualError = null;

        try {
            reportsClient.invokeMethod(ServiceNames.REPORTS, LOGIN, null, json, ReportProcessingMode.ONLINE, 5);
        } catch (Api5JsonError gotError) {
            actualError = gotError;
        }

        assertThat("получена правильная ошибка", actualError,
                new Api5JsonErrorMatcher(new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY, "FieldNames").toJsonError()));
    }

    @Test
    @Description("Нет обязательного параметра DateRangeType")
    public void testMissingParam() {
        api.userSteps.reportsSteps().shouldGetReportsJsonErrorOn(LOGIN,
                new ReportDefinitionMap()
                        .withDefaultCustomReportWithUniqueReportName()
                        .withSelectionCriteria(new SelectionCriteriaMap())
                        .withDateRangeType(null),
                new Api5Error(8000,
                        Api5ErrorDetails.MISSING_REQUIRED_FIELD, "params", "DateRangeType"));
    }

    @Test
    @Description("Неизвестный параметр ProvideExtraData")
    public void testUnknownParam() {
        String json = "{\n"
                + "    \"params\" : {\n"
                + "        \"SelectionCriteria\" : {\n"
                + "            \"Filter\" : [{\n"
                + "                \"Field\" : \"CampaignId\",\n"
                + "                \"Operator\" : \"EQUALS\",\n"
                + "                \"Values\" : [ 1287989 ]\n"
                + "            }]\n"
                + "        },\n"
                + "        \"FieldNames\" : [\"CampaignId\", \"AdId\"],\n"
                + "        \"Page\" : { \"Limit\" : 10 },\n"
                + "        \"ReportName\" : \"testReport 20170220-1\",\n"
                + "        \"ReportType\" : \"CUSTOM_REPORT\",\n"
                + "        \"DateRangeType\" : \"LAST_WEEK\",\n"
                + "        \"Format\" : \"TSV\",\n"
                + "        \"IncludeVAT\" : \"YES\",\n"
                + "        \"ProvideExtraData\" : \"aaa\",\n" // ProvideExtraData -- неизвестный параметр
                + "        \"IncludeDiscount\" : \"YES\"\n"
                + "    }\n"
                + "}";

        Api5JsonError actualError = null;

        try {
            reportsClient.invokeMethod(ServiceNames.REPORTS, LOGIN, null, json);
        } catch (Api5JsonError gotError) {
            actualError = gotError;
        }

        assertThat("получена правильная ошибка", actualError,
                new Api5JsonErrorMatcher(new Api5Error(8000,
                        Api5ErrorDetails.PARAMS_CONTAINS_UNKNOWN_FIELD, "ProvideExtraData"
                        ).toJsonError()));
    }

}