package ru.yandex.autotests.directapi.reports;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Created by pavryabov on 05.07.16.
 */
@RunWith(Parameterized.class)
@Features(ApiFeatures.NOT_REGRESSION_YET)
public class ReportTypeTest {

    private static final String CLIENT = ReportsLogins.REPORTS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public ReportTypeEnum reportType;

    @Parameterized.Parameters(name = "ReportType = {0}")
    public static Collection<Object[]> data() {
        List<Object[]> data = new ArrayList<Object[]>();
        for (ReportTypeEnum reportTypeEnum : ReportTypeEnum.values()) {
            data.add(new Object[]{reportTypeEnum});
        }
        return data;
    }

    @Test
    public void expectErrorWithFieldNames() {
        //DIRECT-55775
        //DIRECT-55808
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withFieldNames(FieldEnum.AD_ID)
                .withDateRangeType(DateRangeTypeEnum.LAST_MONTH)
                .withUniqueReportName()
                .withReportType(reportType)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES)
                .withSelectionCriteria(new SelectionCriteriaMap());
        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap, new Api5Error(54, Api5ErrorDetails.AD));
    }
}
