package ru.yandex.autotests.directapi.reports;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportResponse;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;

/**
 * Created by lightelfik on 19.09.17.
 */
@Features({ReportsFeatures.OFFLINE_CUSTOM_REPORT})
public class ReportsHeadersTest {
    private static final String LOGIN = ReportsLogins.CLIENT_FOR_RESTRICTIONS;
    private static final int OFFLINE_REPORTS_QUEUE_SIZE = 5;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().setApiReportsLimit(LOGIN, OFFLINE_REPORTS_QUEUE_SIZE);
    }

    @Test
    public void reportsInQueueTest() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withCampaignIds(12345L);

        ReportResponse response = api.userSteps.reportsSteps()
                .callReportsXmlGetOfflineReportResponse(reportDefinitionMap);
        String reportsInQueue = response.getHeaders().get("reportsInQueue");

        assertThat("вернулся заголовок reportsInQueue", reportsInQueue, notNullValue());
    }
}
