package ru.yandex.autotests.directapi.reports;

import com.yandex.direct.api.v5.reports.*;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.assertThat;

/**
 * Created by pavryabov on 01.06.16.
 */
@Features({ReportsFeatures.ONLINE_CUSTOM_REPORT, ApiFeatures.SMOKE})
public class ReportsSmokeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_RUB_WITH_STAT3);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    public void test() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName().withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.CAMPAIGN_ID)
                                .withOperator(FilterOperatorEnum.EQUALS)
                                .withValues("1287989")));
        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("вернулся непустой отчёт", reportsData.getReportsLines(), not(empty()));
    }
}
