package ru.yandex.autotests.directapi.reports;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.reports.FieldEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportProcessingMode;
import ru.yandex.autotests.directapi.model.api5.reports.ReportResponse;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by gerdler on 20.03.17.
 */

@Aqua.Test
@Description("Проверяем исключение частей из отчета при использовании HTTP-заголовков skipReportHeader, skipColumnHeader и skipReportSummary")
@Issue("https://st.yandex-team.ru/DIRECT-64380")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class SkipReportPartsTest {

    private static final String DATE = "2019-12-02";
    private static final String DATE_WITHOUT_STAT = "2020-01-01";
    private static final Long CAMPAIGN_ID = 1287989L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_RUB_WITH_STAT3);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public ReportProcessingMode processingMode;

    @Parameterized.Parameter(1)
    public String description;

    @Parameterized.Parameter(2)
    public Boolean skipReportHeader;

    @Parameterized.Parameter(3)
    public Boolean skipColumnHeader;

    @Parameterized.Parameter(4)
    public Boolean skipReportSummary;

    @Parameterized.Parameter(5)
    public Boolean skipReportData;

    @Parameterized.Parameter(6)
    public String date;

    @Parameterized.Parameters(name = "{0} {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {ReportProcessingMode.ONLINE, "без строки заголовка", true, null, null, false, DATE},
                {ReportProcessingMode.ONLINE, "без строки с названиями столбцов", null, true, null, false, DATE},
                {ReportProcessingMode.ONLINE, "без строки с количеством строк", null, null, true, false, DATE},
                {ReportProcessingMode.ONLINE, "без строки заголовка и строки с названиями столбцов", true, true, null, false, DATE},
                {ReportProcessingMode.ONLINE, "без строки заголовка, строки с названиями столбцов и строки с количеством строк", true, true, true, false, DATE},
//                {ReportProcessingMode.OFFLINE, "без строки заголовка", true, null, null, false, DATE}, # отключили из-за проблемы в тестовом MDS с истечением TTL
                {ReportProcessingMode.OFFLINE, "без строки с названиями столбцов", null, true, null, false, DATE},
                {ReportProcessingMode.OFFLINE, "без строки с количеством строк", null, null, true, false, DATE},
                {ReportProcessingMode.OFFLINE, "без строки с названиями столбцов и строки с количеством строк", null, true, true, false, DATE},
                {ReportProcessingMode.ONLINE, "пустой отчет", true, true, true, true, DATE_WITHOUT_STAT},
                {ReportProcessingMode.OFFLINE, "пустой отчет", true, true, true, true, DATE_WITHOUT_STAT},
        };
        return Arrays.asList(data);
    }
    @Test
    public void skipReportLineTest() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withCustomDatesAndCampaignIds(date, date, CAMPAIGN_ID)
                .withFieldNames(FieldEnum.IMPRESSIONS,FieldEnum.CLICKS);
        ReportResponse reportResponse = api.processingMode(processingMode)
                .skipReportHeader(skipReportHeader).skipColumnHeader(skipColumnHeader).skipReportSummary(skipReportSummary)
                .userSteps.reportsSteps().callReportsXmlGetReportResponse(reportDefinitionMap);
        String expectedReportContent = "";
        if (skipReportHeader == null || !skipReportHeader) {
            expectedReportContent += "\"" + reportDefinitionMap.getReportName() + " (" + DATE + " - " + DATE + ")\"\n";
        }
        if (skipColumnHeader == null || !skipColumnHeader) {
            expectedReportContent += "Impressions\tClicks\n";
        }
        if (!skipReportData) {
            expectedReportContent += "423\t52\n";
        }
        if (skipReportSummary == null || !skipReportSummary) {
            expectedReportContent += "Total rows: 1\n";
        }
        assertThat("вернулся отчёт " + description, reportResponse.getContent(), equalTo(expectedReportContent));
    }
}