package ru.yandex.autotests.directapi.reports;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.OrderByMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by onotole on 21.07.16.
 * https://st.yandex-team.ru/TESTIRT-9734
 */
@Aqua.Test
@Description("Проверка работы группировок для не CUSTOM REPORT, негативные тесты")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ApiFeatures.NOT_REGRESSION_YET)
public class VariousTypeOfReportsNegativeTest {
    private static final String CLIENT = ReportsLogins.CLIENT_RUB_WITH_STAT3;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

//    @Test
//    public void checkAdGroupPerformanceReportWithBadFieldName() {
//        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(FieldEnum.AD_ID)
//                .withReportName("test report")
//                .withReportType(ReportTypeEnum.ADGROUP_PERFORMANCE_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap())
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//
//        // ошибка будет уточнена после https://st.yandex-team.ru/DIRECT-56448
//        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap, new Api5Error(4000, Api5ErrorDetails.ALLOWED_TO_FILTER_THIS_FIELD_ONLY_OPERATORS));
//    }
//
//    @Test
//    public void checkCampaignPerformanceReportWithBadFieldName() {
//        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(FieldEnum.AD_GROUP_ID, FieldEnum.AD_ID, FieldEnum.AD_GROUP_NAME)
//                .withOrderBy(new OrderByMap()
//                        .withField(FieldEnum.AD_NETWORK_TYPE))
//                .withReportName("test report")
//                .withReportType(ReportTypeEnum.CAMPAIGN_PERFORMANCE_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap())
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//
//        // ошибка будет уточнена после https://st.yandex-team.ru/DIRECT-56448
//        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap, new Api5Error(4000, Api5ErrorDetails.ALLOWED_TO_FILTER_THIS_FIELD_ONLY_OPERATORS));
//    }

}
