package ru.yandex.autotests.directapi.reports;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestStepsEn.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by onotole on 21.07.16.
 * https://st.yandex-team.ru/TESTIRT-9734
 */
@Aqua.Test
@Description("Проверка работы группировок для не CUSTOM REPORT")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ApiFeatures.NOT_REGRESSION_YET)
public class VariousTypeOfReportsTest {
    private static final String CLIENT = ReportsLogins.CLIENT_RUB_WITH_STAT3;
    private static final String REPORT_NAME = "test report";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

//    @Test
//    public void checkCampaignPerformanceReport() {
//        FieldEnum[] fieldEnums = {FieldEnum.CAMPAIGN_ID, FieldEnum.AGE, FieldEnum.YEAR, FieldEnum.AD_GROUP_ID, FieldEnum.AD_ID};
//
//        ReportDefinitionMap specialReportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(fieldEnums)
//                .withReportName(REPORT_NAME)
//                .withReportType(ReportTypeEnum.CAMPAIGN_PERFORMANCE_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap( ))
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//        ReportsData specialReportsData = api.userSteps.reportsSteps().callReportsXml(specialReportDefinitionMap);
//
//        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(fieldEnums)
//                .withReportName(REPORT_NAME)
//                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap())
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
//
//        assertThat("в CAMPAIGN_PERFORMANCE_REPORT группировка работает правильно", specialReportsData, beanDiffer(reportsData));
//    }
//
//
//    @Test
//    public void checkAdPerformanceReport() {
//        FieldEnum[] fieldEnums = {FieldEnum.AD_ID, FieldEnum.CAMPAIGN_ID, FieldEnum.AGE, FieldEnum.YEAR, FieldEnum.AD_GROUP_ID};
//
//        ReportDefinitionMap specialReportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(fieldEnums)
//                .withReportName(REPORT_NAME)
//                .withReportType(ReportTypeEnum.AD_PERFORMANCE_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap( ))
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//        ReportsData specialReportsData = api.userSteps.reportsSteps().callReportsXml(specialReportDefinitionMap);
//
//        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(fieldEnums)
//                .withReportName(REPORT_NAME)
//                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap())
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
//
//        assertThat("в AD_PERFORMANCE_REPORT группировка работает правильно", specialReportsData, beanDiffer(reportsData));
//    }
//
//    @Test
//    public void checkAdGroupPerformanceReport() {
//        FieldEnum[] fieldEnums = {FieldEnum.AD_GROUP_ID, FieldEnum.AD_ID, FieldEnum.CAMPAIGN_ID, FieldEnum.AGE, FieldEnum.YEAR};
//
//        ReportDefinitionMap specialReportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(fieldEnums)
//                .withReportName(REPORT_NAME)
//                .withReportType(ReportTypeEnum.ADGROUP_PERFORMANCE_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap( ))
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//        ReportsData specialReportsData = api.userSteps.reportsSteps().callReportsXml(specialReportDefinitionMap);
//
//        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(fieldEnums)
//                .withReportName(REPORT_NAME)
//                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap())
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
//
//        assertThat("в ADGROUP_PERFORMANCE_REPORT группировка работает правильно", specialReportsData, beanDiffer(reportsData));
//    }
//
//
//    @Test
//    public void checkGeoPerformanceReport() {
//        FieldEnum[] fieldEnums = {FieldEnum.TARGETING_LOCATION_ID, FieldEnum.AD_GROUP_ID, FieldEnum.CAMPAIGN_ID, FieldEnum.YEAR};
//
//        ReportDefinitionMap specialReportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(fieldEnums)
//                .withReportName(REPORT_NAME)
//                .withReportType(ReportTypeEnum.GEO_PERFORMANCE_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap( ))
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//        ReportsData specialReportsData = api.userSteps.reportsSteps().callReportsXml(specialReportDefinitionMap);
//
//        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(fieldEnums)
//                .withReportName(REPORT_NAME)
//                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap())
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
//
//        assertThat("в GEO_PERFORMANCE_REPORT группировка работает правильно", specialReportsData, beanDiffer(reportsData));
//    }
//
//    @Test
//    public void checkKeywordsPerformanceReport() {
//        FieldEnum[] fieldEnums = {FieldEnum.CRITERIA, FieldEnum.CAMPAIGN_ID, FieldEnum.MONTH, FieldEnum.AGE};
//
//        ReportDefinitionMap specialReportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(fieldEnums)
//                .withReportName(REPORT_NAME)
//                .withReportType(ReportTypeEnum.KEYWORDS_PERFORMANCE_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap( ))
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//        ReportsData specialReportsData = api.userSteps.reportsSteps().callReportsXml(specialReportDefinitionMap);
//
//        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
//                .withFieldNames(fieldEnums)
//                .withReportName(REPORT_NAME)
//                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
//                .withFormat(FormatEnum.TSV)
//                .withIncludeVAT(YesNoEnum.YES)
//                .withIncludeDiscount(YesNoEnum.YES)
//                .withSelectionCriteria(new SelectionCriteriaMap())
//                .withDateRangeType(DateRangeTypeEnum.ALL_TIME);
//        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
//
//        assertThat("в KEYWORDS_PERFORMANCE_REPORT группировка работает правильно", specialReportsData, beanDiffer(reportsData));
//    }

}
