package ru.yandex.autotests.directapi.reports;

import java.util.Collection;
import java.util.LinkedList;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersHidden;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasSize;
import static org.junit.Assert.assertThat;

/**
 * Created by andy-ilyin on 29.09.16.
 */
@Aqua.Test
@Description("Проверка работы полей IncludeVat, IncludeDiscount")
@Issue("https://st.yandex-team.ru/TESTIRT-9732")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public final class VatDiscountTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private enum ClientCurrency {
        RUB(ReportsLogins.CLIENT_RUB_WITH_STAT4),
        EUR(ReportsLogins.CLIENT_EUR_WITH_STAT2);

        private String clientLogin;

        ClientCurrency(String clientLogin) {
            this.clientLogin = clientLogin;
        }
    }

    private final static String DATE_FROM = "2019-08-01";
    private final static String DATE_TO = "2019-08-29";

    public static final class TestCase {
        private final ClientCurrency clientCurrency;
        private final YesNoEnum includeVat;
        private final YesNoEnum includeDiscount;

        private TestCase(ClientCurrency clientCurrency, boolean includeVat, boolean includeDiscount) {
            this.clientCurrency = clientCurrency;
            this.includeVat = includeVat ? YesNoEnum.YES : YesNoEnum.NO;
            this.includeDiscount = includeDiscount ? YesNoEnum.YES : YesNoEnum.NO;
        }

        @Override
        public String toString() {
            return String.format("currency=%s, fakeLogin=%s, includeVat=%s, includeDiscount=%s",
                    clientCurrency, clientCurrency.clientLogin, includeVat, includeDiscount);
        }
    }

    @Parameterized.Parameter
    public TestCase currentTestCase;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testCases() {
        return new LinkedList<Object[]>() {{

            add(new Object[]{new TestCase(ClientCurrency.RUB, false, false)});
            add(new Object[]{new TestCase(ClientCurrency.RUB, false, true)});
            add(new Object[]{new TestCase(ClientCurrency.RUB, true, false)});
            add(new Object[]{new TestCase(ClientCurrency.RUB, true, true)});

            add(new Object[]{new TestCase(ClientCurrency.EUR, false, false)});
            add(new Object[]{new TestCase(ClientCurrency.EUR, false, true)});
            add(new Object[]{new TestCase(ClientCurrency.EUR, true, false)});
            add(new Object[]{new TestCase(ClientCurrency.EUR, true, true)});
        }};
    }

    @Before
    @Description("Поставить пользователю флаг hidden, если он в у. е., чтобы он не попадал под тизер конвертации")
    public final void setUserHidden() {

        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps();

        dbSteps.useShardForLogin(currentTestCase.clientCurrency.clientLogin);

        Long uid = dbSteps.usersSteps()
                .getUser(currentTestCase.clientCurrency.clientLogin)
                .getUid();
        dbSteps.usersSteps().setUsersHidden(uid, UsersHidden.Yes);
    }

    @Test
    public final void testVatAndDiscount() {
        api.as(Logins.LOGIN_SUPER).clientLogin(currentTestCase.clientCurrency.clientLogin);

        ReportDefinitionMap reportRequest = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withCustomDates(DATE_FROM, DATE_TO)
                .withIncludeVAT(currentTestCase.includeVat)
                .withIncludeDiscount(currentTestCase.includeDiscount);

        ReportsData reportResponse = api.userSteps.reportsSteps().callReportsXml(reportRequest);
        assertThat("вернулся отчёт", reportResponse.getReportsLines(), hasSize(greaterThan(0)));
    }
}
