package ru.yandex.autotests.directapi.reports.accountreport;

import java.util.stream.Collectors;

import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.statistics.ReportsSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 01.03.17.
 */
@Aqua.Test
@Description("ACCOUNT_PERFORMANCE_REPORT возвращает те же данные, что и CUSTOM_REPORT")
@Issue("https://st.yandex-team.ru/DIRECT-62409")
@Features(ReportsFeatures.ACCOUNT_PERFORMANCE_REPORT)
public class AccountPerformanceReportCompareWithCustomReportTest {
    private static final String DATE_FROM = "2019-12-01";
    private static final String DATE_TO = "2019-12-06";

    private static final FieldEnum[] FIELD_NAMES = new FieldEnum[] {
            FieldEnum.DATE,
            FieldEnum.AGE,
            FieldEnum.GENDER,
            FieldEnum.AD_NETWORK_TYPE,
            FieldEnum.AVG_CPC,
            FieldEnum.CONVERSIONS,
            FieldEnum.IMPRESSIONS,
            FieldEnum.CLICKS,
            FieldEnum.CRITERIA_TYPE,
            FieldEnum.COST,
            FieldEnum.CTR,
            FieldEnum.PROFIT,
            FieldEnum.TARGETING_CATEGORY,
            FieldEnum.INCOME_GRADE
    };

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_FOR_ACCOUNT_PERFORMANCE_REPORT4);

    private static final ReportsSteps REPORTS_STEPS = api.userSteps.reportsSteps();

    @Test
    public void test() {
        ReportsData accountPerformanceReport = REPORTS_STEPS.callReportsXml(new ReportDefinitionMap()
                .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.ACCOUNT_PERFORMANCE_REPORT)
                .withCustomDates(DATE_FROM, DATE_TO)
                .withFieldNames(FIELD_NAMES)
                .withPage(null));

        assumeThat("отчёт ACCOUNT_PERFORMANCE_REPORT не пустой",
                accountPerformanceReport.getReportsLines(), not(empty()));

        ReportsData customReport = REPORTS_STEPS.callReportsXml(new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withCustomDates(DATE_FROM, DATE_TO)
                .withFieldNames(FIELD_NAMES)
                .withPage(null));

        assertThat("в отчётах одни и те же данные",
                accountPerformanceReport.getReportsLines(),
                containsInAnyOrder(customReport.getReportsLines().stream()
                        .map(BeanDifferMatcher::beanDiffer)
                        .collect(Collectors.toList())));
    }
}
