package ru.yandex.autotests.directapi.reports.adgroupreport;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import java.util.Arrays;
import java.util.Collection;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by gerdler on 23.01.17.
 * https://st.yandex-team.ru/TESTIRT-10890
 */
@Aqua.Test
@Description("ADGROUP_PERFORMANCE_REPORT: проверка получения ошибки при использовании ImpressionShare с несовместими полями")
@Issue("https://st.yandex-team.ru/DIRECT-56577")
@Features(ReportsFeatures.ADGROUP_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class AdGroupPerformanceReportImpressionShareIncompatibleFieldNamesNegativeTest {
    private static final String CLIENT = ReportsLogins.CLIENT_FOR_ADGROUP_PERFORMANCE_REPORT2;
    private final static String INCOMPATIBLE_FIELDS = "AdFormat, Age, CarrierType, Gender, MobilePlatform";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @Parameterized.Parameter(0)
    public FieldEnum incompatibleField;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {FieldEnum.AD_FORMAT},
                {FieldEnum.AGE},
                {FieldEnum.CARRIER_TYPE},
                {FieldEnum.GENDER},
                {FieldEnum.MOBILE_PLATFORM}
        });
    }

    @Test
    public void impressionShareInFieldNamesAndIncompatibleFieldInFieldNames() {
        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                new ReportDefinitionMap()
                        .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.ADGROUP_PERFORMANCE_REPORT)
                        .withDateRangeType(DateRangeTypeEnum.TODAY)
                        .withSelectionCriteria(new SelectionCriteriaMap())
                        .withFieldNames(
                                FieldEnum.IMPRESSION_SHARE,
                                incompatibleField
                        ),
                new Api5Error(4000, Api5ErrorDetails.INCOMPATIBLE_FIELDS_IN_FIELDNAMES,
                        FieldEnum.IMPRESSION_SHARE.value(),
                        capitalize(ReportDefinitionMap.FIELD_NAMES),
                        INCOMPATIBLE_FIELDS,
                        ReportTypeEnum.ADGROUP_PERFORMANCE_REPORT
                )
        );
    }
}
