package ru.yandex.autotests.directapi.reports.adgroupreport;

import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import java.util.Arrays;
import java.util.Collection;

@Aqua.Test
@Description("ADGROUP_PERFORMANCE_REPORT: FieldNames, отрицательные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-63914")
@Features(ReportsFeatures.ADGROUP_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class AdgroupPerformanceReportFieldNamesNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_FOR_ADGROUP_PERFORMANCE_REPORT1);

    @Parameterized.Parameter
    public FieldEnum fieldName;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][] {
                new Object[] { FieldEnum.AD_ID },
                new Object[] { FieldEnum.AUDIENCE_TARGET_ID },
                new Object[] { FieldEnum.CRITERIA },
                new Object[] { FieldEnum.CRITERIA_ID },
                new Object[] { FieldEnum.CRITERION },
                new Object[] { FieldEnum.CRITERION_ID },
                new Object[] { FieldEnum.MATCHED_KEYWORD },
                new Object[] { FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID },
                new Object[] { FieldEnum.KEYWORD },
                new Object[] { FieldEnum.QUERY },
                new Object[] { FieldEnum.RL_ADJUSTMENT_ID },
                new Object[] { FieldEnum.SMART_BANNER_FILTER_ID },
        };

        return Arrays.asList(result);
    }

    @Test
    public void test() {
        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                new ReportDefinitionMap()
                        .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.ADGROUP_PERFORMANCE_REPORT)
                        .withSelectionCriteria(new SelectionCriteriaMap())
                        .withFieldNames(fieldName),
                new Api5Error(4000,
                        Api5ErrorDetails.REPORTS_UNSUPPORTED_FIELD_IN_FIELD_NAMES_WITH_REPORT_TYPE,
                        fieldName.value(), ReportTypeEnum.ADGROUP_PERFORMANCE_REPORT.name()));
    }
}
