package ru.yandex.autotests.directapi.reports.backtoback;

import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.elliptics.Elliptics;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by andy-ilyin on 01.12.16.
 */
@Aqua.Test
@Features(ReportsFeatures.BACK_TO_BACK)
@Stories(ApiStories.B2B)
@RunWith(Parameterized.class)
@Description("Сохранение отчетов reports для b2b в эллиптикс")
public class GenerateReportsTest extends TestBase {
    private static LogSteps log = LogSteps.getLogger(TestBase.class);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return calculateParameters(getTestFilesToRunBasedOnProperties());
    }

    @BeforeClass
    public static void checkProperties() {
        DirectTestRunProperties properties = DirectTestRunProperties.getInstance();

        if (properties.isApi5ReportsBacktobackResponsesInIndefiniteStorage() &&
                !properties.isApi5ReportsBacktobackAllowedWriteResponsesInIndefiniteStorage()) {
            throw new IllegalArgumentException("configuration doesn't allow for writing responses to indefinite storage");
        }
    }

    @Test
    @Override
    public void test() {
        ReportsData report = api.userSteps.reportsSteps().callReportsXml(reportRequest, clientLogin);
        assumeThat("отчёт не пустой", report.getReportsLines(), not(empty()));

        String fileName = getEllipticsRequestsFileName();

        Elliptics elliptics = new Elliptics();
        elliptics.update(getComparableReportString(report), fileName);
        log.info(elliptics.getUrlForName(fileName));
    }
}
