package ru.yandex.autotests.directapi.reports.criteriaid;

import java.util.stream.Collectors;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import org.hamcrest.core.Every;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.MatchTypeEnum;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsLine;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by andy-ilyin on 15.12.16.
 */
@Aqua.Test
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-59903"),
        @Issue("https://st.yandex-team.ru/DIRECT-60878")
})
@Description("Проверка, что CriteriaId для MatchType = SYNONYM отдаются правильно")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class SynonymCriteriaIdTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.AUDIENCE_TARGET_ID_CLIENT);

    @Test
    public void test() {
        ReportsData report = api.userSteps.reportsSteps().callReportsXml(new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withPage(null)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom("2019-10-01")
                        .withDateTo("2019-10-01")
                        .withFilter(
                                new FilterItemMap()
                                        .withField(FieldEnum.CAMPAIGN_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("6827883"),
                                new FilterItemMap()
                                        .withField(FieldEnum.AD_GROUP_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("167273649"),
                                new FilterItemMap()
                                        .withField(FieldEnum.AD_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("171299781"),
                                new FilterItemMap()
                                        .withField(FieldEnum.MATCH_TYPE)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(MatchTypeEnum.SYNONYM.value())
                        )
                )
                .withFieldNames(
                        FieldEnum.CAMPAIGN_ID,
                        FieldEnum.AD_GROUP_ID,
                        FieldEnum.AD_ID,
                        FieldEnum.CRITERIA_TYPE,
                        FieldEnum.DATE,
                        FieldEnum.CRITERIA_ID
                )
        );

        assumeThat("отчёт не пустой", report.getReportsLines(), not(empty()));

        assertThat("во всех строках отчёта правильный CriteriaId",
                report.getReportsLines().stream()
                        .map(ReportsLine::getCriteriaId)
                        .collect(Collectors.toList()),
                Every.everyItem(equalTo(4193676352L)));
    }
}