package ru.yandex.autotests.directapi.reports.criteriareport;

import java.util.stream.Collectors;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.statistics.ReportsSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by andy-ilyin on 13.01.17.
 */
@Aqua.Test
@Description("CRITERIA_PERFORMANCE_REPORT возвращает те же данные, что и CUSTOM_REPORT")
@Issue("https://st.yandex-team.ru/TESTIRT-10893")
@Features(ReportsFeatures.CRITERIA_PERFORMANCE_REPORT)
public class CriteriaPerformanceReportCompareWithCustomReportTest {
    private static final long CAMPAIGN_ID = 5532455L;
    private static final String DATE_FROM = "2019-12-25";
    private static final String DATE_TO = "2019-12-31";

    private static final FieldEnum[] FIELD_NAMES = new FieldEnum[] {
            // по этим двум полям в этом типе отчёта всегда неявная группировка
            FieldEnum.CRITERIA_TYPE,
            FieldEnum.CRITERIA_ID,

            FieldEnum.DATE,
            FieldEnum.CAMPAIGN_ID,
            FieldEnum.AD_GROUP_ID,
            FieldEnum.CRITERIA,
            FieldEnum.IMPRESSIONS,
            FieldEnum.CLICKS,
            FieldEnum.COST,
            FieldEnum.CTR,
            FieldEnum.TARGETING_CATEGORY,
            FieldEnum.INCOME_GRADE
    };

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT1);

    private static final ReportsSteps REPORTS_STEPS = api.userSteps.reportsSteps();

    @Test
    public void test() {
        ReportsData criteriaPerformanceReport = REPORTS_STEPS.callReportsXml(new ReportDefinitionMap()
                .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.CRITERIA_PERFORMANCE_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(DATE_FROM)
                        .withDateTo(DATE_TO)
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.CAMPAIGN_ID)
                                .withOperator(FilterOperatorEnum.EQUALS)
                                .withValues(CAMPAIGN_ID)))
                .withFieldNames(FIELD_NAMES)
                .withPage(null));

        assumeThat("отчёт CRITERIA_PERFORMANCE_REPORT не пустой",
                criteriaPerformanceReport.getReportsLines(), not(empty()));

        ReportsData customReport = REPORTS_STEPS.callReportsXml(new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(DATE_FROM)
                        .withDateTo(DATE_TO)
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.CAMPAIGN_ID)
                                .withOperator(FilterOperatorEnum.EQUALS)
                                .withValues(CAMPAIGN_ID)))
                .withFieldNames(FIELD_NAMES)
                .withPage(null));

        assertThat("в отчётах одни и те же данные",
                criteriaPerformanceReport.getReportsLines(),
                containsInAnyOrder(customReport.getReportsLines().stream()
                        .map(BeanDifferMatcher::beanDiffer)
                        .collect(Collectors.toList())));
    }
}
