package ru.yandex.autotests.directapi.reports.criteriareport;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by andy-ilyin on 13.01.17.
 */
@Aqua.Test
@Description("CRITERIA_PERFORMANCE_REPORT: FieldNames, положительные сценарии")
@Issue("https://st.yandex-team.ru/TESTIRT-10893")
@Features(ReportsFeatures.CRITERIA_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class CriteriaPerformanceReportFieldNamesPositiveTest {
    private final static long CAMPAIGN_ID = 20211961L;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT2);

    @Parameterized.Parameter
    public FieldEnum fieldName;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][] {
                new Object[] { FieldEnum.AD_GROUP_ID },
                new Object[] { FieldEnum.AD_GROUP_NAME },
                new Object[] { FieldEnum.AD_NETWORK_TYPE },
                new Object[] { FieldEnum.AGE },
                new Object[] { FieldEnum.AVG_CLICK_POSITION },
                new Object[] { FieldEnum.AVG_CPC },
                new Object[] { FieldEnum.AVG_IMPRESSION_POSITION },
                new Object[] { FieldEnum.AVG_PAGEVIEWS },
                new Object[] { FieldEnum.BOUNCE_RATE },
                new Object[] { FieldEnum.BOUNCES },
                new Object[] { FieldEnum.CAMPAIGN_ID },
                new Object[] { FieldEnum.CAMPAIGN_NAME },
                new Object[] { FieldEnum.CAMPAIGN_TYPE },
                new Object[] { FieldEnum.CARRIER_TYPE },
                new Object[] { FieldEnum.CLICK_TYPE },
                new Object[] { FieldEnum.CLICKS },
                new Object[] { FieldEnum.CONVERSION_RATE },
                new Object[] { FieldEnum.CONVERSIONS },
                new Object[] { FieldEnum.COST },
                new Object[] { FieldEnum.COST_PER_CONVERSION },
                new Object[] { FieldEnum.CRITERIA },
                new Object[] { FieldEnum.CRITERIA_ID },
                new Object[] { FieldEnum.CRITERION },
                new Object[] { FieldEnum.CRITERION_ID },
                new Object[] { FieldEnum.CRITERIA_TYPE },
                new Object[] { FieldEnum.CRITERION_TYPE },
                new Object[] { FieldEnum.CTR },
                new Object[] { FieldEnum.DATE },
                new Object[] { FieldEnum.DEVICE },
                new Object[] { FieldEnum.EXTERNAL_NETWORK_NAME },
                new Object[] { FieldEnum.GENDER },
                new Object[] { FieldEnum.GOALS_ROI },
                new Object[] { FieldEnum.IMPRESSIONS },
                new Object[] { FieldEnum.LOCATION_OF_PRESENCE_ID },
                new Object[] { FieldEnum.LOCATION_OF_PRESENCE_NAME },
                new Object[] { FieldEnum.MOBILE_PLATFORM },
                new Object[] { FieldEnum.MONTH },
                new Object[] { FieldEnum.QUARTER },
                new Object[] { FieldEnum.PLACEMENT },
                new Object[] { FieldEnum.PROFIT },
                new Object[] { FieldEnum.REVENUE },
                new Object[] { FieldEnum.RL_ADJUSTMENT_ID },
                new Object[] { FieldEnum.SESSIONS },
                new Object[] { FieldEnum.SLOT },
                new Object[] { FieldEnum.TARGETING_LOCATION_ID },
                new Object[] { FieldEnum.TARGETING_LOCATION_NAME },
                new Object[] { FieldEnum.WEEK },
                new Object[] { FieldEnum.YEAR },
                new Object[] { FieldEnum.TARGETING_CATEGORY },
                new Object[] { FieldEnum.INCOME_GRADE },
        };

        return Arrays.asList(result);
    }

    @Test
    public void test() {
        ReportsData report = api.userSteps.reportsSteps().callReportsXml(new ReportDefinitionMap()
                .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.CRITERIA_PERFORMANCE_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom("2019-12-02")
                        .withDateTo("2019-12-08")
                        .withFilter(
                                new FilterItemMap()
                                        .withField(FieldEnum.CAMPAIGN_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(CAMPAIGN_ID)))
                .withFieldNames(fieldName));

        assertThat("вернулся непустой отчёт", report.getReportsLines(), not(empty()));
    }
}
