package ru.yandex.autotests.directapi.reports.criteriareport;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by andy-ilyin on 13.01.17.
 */
@Aqua.Test
@Description("CRITERIA_PERFORMANCE_REPORT: Filter, отрицательные сценарии")
@Issue("https://st.yandex-team.ru/TESTIRT-10893")
@Features(ReportsFeatures.CRITERIA_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class CriteriaPerformanceReportFilterNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_FOR_NEGATIVE5);

    @Parameterized.Parameter
    public FieldEnum fieldName;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][] {
                new Object[] { FieldEnum.AD_FORMAT },
                new Object[] { FieldEnum.AD_GROUP_NAME },
                new Object[] { FieldEnum.AD_ID },
                new Object[] { FieldEnum.BOUNCES },
                new Object[] { FieldEnum.CAMPAIGN_NAME },
                new Object[] { FieldEnum.CRITERIA },
                new Object[] { FieldEnum.CRITERIA_ID },
                new Object[] { FieldEnum.CRITERION },
                new Object[] { FieldEnum.CRITERION_ID },
                new Object[] { FieldEnum.MATCHED_KEYWORD },
                new Object[] { FieldEnum.DATE },
                new Object[] { FieldEnum.LOCATION_OF_PRESENCE_NAME },
                new Object[] { FieldEnum.MONTH },
                new Object[] { FieldEnum.QUARTER },
                new Object[] { FieldEnum.QUERY },
                new Object[] { FieldEnum.SESSIONS },
                new Object[] { FieldEnum.TARGETING_LOCATION_NAME },
                new Object[] { FieldEnum.WEEK },
                new Object[] { FieldEnum.YEAR },
        };

        return Arrays.asList(result);
    }

    @Test
    public void test() {
        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                new ReportDefinitionMap()
                        .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.CRITERIA_PERFORMANCE_REPORT)
                        .withDateRangeType(DateRangeTypeEnum.TODAY)
                        .withSelectionCriteria(new SelectionCriteriaMap()
                                .withFilter(new FilterItemMap()
                                        .withField(fieldName)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("")))
                        .withFieldNames(FieldEnum.DATE),
                new Api5Error(4001, Api5ErrorDetails.WRONG_VALUE_FOR_THIS_PARAMETER, "Filter.Field",
                        fieldName.value(), ReportTypeEnum.CRITERIA_PERFORMANCE_REPORT));

    }
}
