package ru.yandex.autotests.directapi.reports.criteriareport;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.hamcrest.Matcher;
import org.hamcrest.core.Every;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.PageMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsLine;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasProperty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by andy-ilyin on 20.01.17.
 */
@Aqua.Test
@Description("CRITERIA_PERFORMANCE_REPORT: Filter, положительные сценарии, поля, которые не влезают в CriteriaPerformanceReportFilterPositiveTest")
@Issue("https://st.yandex-team.ru/TESTIRT-10893")
@Features(ReportsFeatures.CRITERIA_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class CriteriaPerformanceReportFilterSpecialFieldsPositiveTest {
    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameter(2)
    public String dateFrom;

    @Parameterized.Parameter(3)
    public String dateTo;

    @Parameterized.Parameter(4)
    public FilterItemMap[] filters;

    @Parameterized.Parameter(5)
    public FieldEnum[] resultFieldNames;

    @Parameterized.Parameter(6)
    public Matcher<ReportsLine> rowMatcher;

    @Parameterized.Parameters(name="{0}, login = {1}, dateFrom = {2}, dateTo = {3}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][] {
                new Object[] {
                        "DynamicTextAdTargetId",
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT5,
                        "2019-11-04",
                        "2019-11-10",
                        new FilterItemMap[] {
                                new FilterItemMap()
                                        .withField(FieldEnum.CAMPAIGN_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(14943581),
                                new FilterItemMap()
                                        .withField(FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(701995),
                        },
                        new FieldEnum[] { FieldEnum.CRITERIA_TYPE, FieldEnum.CRITERIA_ID },
                        hasProperty("criteriaId", equalTo(701995L)),
                },
                new Object[] {
                        "RlAdjustmentId",
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT3,
                        "2020-01-01",
                        "2020-01-07",
                        new FilterItemMap[] {
                                new FilterItemMap()
                                        .withField(FieldEnum.CAMPAIGN_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(37136117),
                                new FilterItemMap()
                                        .withField(FieldEnum.RL_ADJUSTMENT_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(1948262)
                        },
                        new FieldEnum[] { FieldEnum.RL_ADJUSTMENT_ID },
                        hasProperty("rlAdjustmentId", equalTo(1948262)),
                },
                new Object[] {
                        "SmartBannerFilterId",
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT7,
                        "2019-11-04",
                        "2019-11-10",
                        new FilterItemMap[] {
                                new FilterItemMap()
                                        .withField(FieldEnum.CAMPAIGN_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(18902030),
                                new FilterItemMap()
                                        .withField(FieldEnum.SMART_BANNER_FILTER_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(550682)
                        },
                        new FieldEnum[] { FieldEnum.CRITERIA_ID },
                        hasProperty("criteriaId", equalTo(550682L)),
                },
        };

        return Arrays.asList(result);
    }

    @Test
    public void test() {
        api.as(Logins.LOGIN_SUPER).clientLogin(login);

        List<FieldEnum> fieldNames = new LinkedList<>(Arrays.asList(resultFieldNames));
        fieldNames.add(0, FieldEnum.DATE);

        if (!fieldNames.contains(FieldEnum.CRITERIA_TYPE)) {
            fieldNames.add(FieldEnum.CRITERIA_TYPE);
        }

        if (!fieldNames.contains(FieldEnum.CRITERIA_ID)) {
            fieldNames.add(FieldEnum.CRITERIA_ID);
        }

        ReportsData report = api.userSteps.reportsSteps().callReportsXml(new ReportDefinitionMap()
                .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.CRITERIA_PERFORMANCE_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(dateFrom)
                        .withDateTo(dateTo)
                        .withFilter(filters))
                .withFieldNames(fieldNames.toArray(new FieldEnum[0]))
                .withPage(new PageMap().withLimit(1500L)));

        assumeThat("отчёт не пустой", report.getReportsLines(), not(empty()));

        assertThat("все строки соответствуют фильтру",
                report.getReportsLines(), Every.everyItem(rowMatcher));
    }
}
