package ru.yandex.autotests.directapi.reports.criteriareport;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by gerdler on 13.03.17.
 * https://st.yandex-team.ru/TESTIRT-10890
 */
@Aqua.Test
@Description("CRITERIA_PERFORMANCE_REPORT: проверка получения ошибки при использовании ImpressionShare с несовместими полями в фильтре")
@Issue("https://st.yandex-team.ru/DIRECT-56577")
@Features(ReportsFeatures.CRITERIA_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class CriteriaPerformanceReportImpressionShareIncompatibleFilterFieldsNegativeTest {
    private static final String CLIENT = ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT14;
    private final static String INCOMPATIBLE_FIELDS = "Age, CarrierType, Gender, MobilePlatform, RlAdjustmentId";
    private final static String INCOMPATIBLE_FILTER_FIELDS = "Age, CarrierType, Gender, MobilePlatform, RlAdjustmentId";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @Parameterized.Parameter(0)
    public FieldEnum incompatibleField;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {FieldEnum.AGE},
                {FieldEnum.CARRIER_TYPE},
                {FieldEnum.GENDER},
                {FieldEnum.MOBILE_PLATFORM},
                {FieldEnum.RL_ADJUSTMENT_ID}
        });
    }

    @Test
    public void ImpressionShareInFieldNamesAndIncompatibleFieldInFilter() {
        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                new ReportDefinitionMap()
                        .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.CRITERIA_PERFORMANCE_REPORT)
                        .withDateRangeType(DateRangeTypeEnum.TODAY)
                        .withSelectionCriteria(
                                new SelectionCriteriaMap()
                                    .withFilter(
                                        new FilterItemMap()
                                                .withField(incompatibleField)
                                                .withOperator(FilterOperatorEnum.IN)
                                                .withValues("1")))
                        .withFieldNames(
                                FieldEnum.IMPRESSION_SHARE
                        ),
                new Api5Error(4001, Api5ErrorDetails.INCOMPATIBLE_FIELDS_IN_FIELDNAMES_AND_FILTER,
                        "Filter.Field",
                        INCOMPATIBLE_FILTER_FIELDS,
                        FieldEnum.IMPRESSION_SHARE.value(),
                        "FieldNames",
                        ReportTypeEnum.CRITERIA_PERFORMANCE_REPORT
                )
        );
    }

    @Test
    public void ImpressionShareInFilterAndIncompatibleFieldInFilter() {
        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                new ReportDefinitionMap()
                        .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.CRITERIA_PERFORMANCE_REPORT)
                        .withDateRangeType(DateRangeTypeEnum.TODAY)
                        .withSelectionCriteria(
                                new SelectionCriteriaMap()
                                        .withFilter(
                                                new FilterItemMap()
                                                        .withField(FieldEnum.IMPRESSION_SHARE)
                                                        .withOperator(FilterOperatorEnum.IN)
                                                        .withValues("1"),
                                                new FilterItemMap()
                                                        .withField(incompatibleField)
                                                        .withOperator(FilterOperatorEnum.IN)
                                                        .withValues("1"))
                        ),
                new Api5Error(4001, Api5ErrorDetails.INCOMPATIBLE_FIELDS_IN_FILTER,
                        "Filter.Field",
                        FieldEnum.IMPRESSION_SHARE.value(),
                        INCOMPATIBLE_FIELDS
                )
        );
    }
}
