package ru.yandex.autotests.directapi.reports.criteriareport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.general.SortOrderEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.OrderByMap;
import ru.yandex.autotests.directapi.model.api5.reports.PageMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsLine;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.matchers.OrderMatcher;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by andy-ilyin on 13.01.17.
 */
@Aqua.Test
@Description("CRITERIA_PERFORMANCE_REPORT: OrderBy, положительные сценарии, которые не помещаются в CriteriaPerformanceReportOrderByPositiveTest")
@Issue("https://st.yandex-team.ru/TESTIRT-10893")
@Features(ReportsFeatures.CRITERIA_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class CriteriaPerformanceReportOrderBySpecialFieldsPositiveTest {
    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Parameterized.Parameter
    public FieldEnum fieldName;

    @Parameterized.Parameter(1)
    public Function<ReportsLine, ?> valueGetter;

    @Parameterized.Parameter(2)
    public FieldEnum[] requestedFieldNames;

    @Parameterized.Parameter(3)
    public String login;

    @Parameterized.Parameter(4)
    public Long[] campaignIds;

    @Parameterized.Parameter(5)
    public String dateFrom;

    @Parameterized.Parameter(6)
    public String dateTo;

    @Parameterized.Parameter(7)
    public FilterItemMap additionalFilter;

    private FilterItemMap[] filters;
    
    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][] {
                new Object[] {
                        FieldEnum.CAMPAIGN_TYPE,
                        (Function<ReportsLine, ?>) ReportsLine::getCampaignType,
                        new FieldEnum[] { FieldEnum.DATE, FieldEnum.CAMPAIGN_ID, FieldEnum.CAMPAIGN_TYPE },
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT8,
                        new Long[] { 56884755L, 37687197L, 28238746L },
                        "2021-11-05",
                        "2021-11-12",
                        null,
                },
                new Object[] {
                        FieldEnum.CONVERSION_RATE,
                        (Function<ReportsLine, ?>) ReportsLine::getConversionRate,
                        new FieldEnum[] {
                                FieldEnum.DATE,
                                FieldEnum.CAMPAIGN_ID,
                                FieldEnum.CRITERIA_TYPE,
                                FieldEnum.CRITERIA_ID,
                                FieldEnum.CONVERSION_RATE },
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT3,
                        new Long[] { 44933891L },
                        "2021-11-01",
                        "2021-11-01",
                        null,
                },
                new Object[] {
                        FieldEnum.CONVERSIONS,
                        (Function<ReportsLine, ?>) ReportsLine::getConversions,
                        new FieldEnum[] {
                                FieldEnum.DATE,
                                FieldEnum.CAMPAIGN_ID,
                                FieldEnum.CRITERIA_TYPE,
                                FieldEnum.CRITERIA_ID,
                                FieldEnum.CONVERSIONS },
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT3,
                        new Long[] { 44933891L },
                        "2021-11-05",
                        "2021-11-05",
                        null,
                },
                new Object[] {
                        FieldEnum.COST_PER_CONVERSION,
                        (Function<ReportsLine, ?>) ReportsLine::getCostPerConversion,
                        new FieldEnum[] {
                                FieldEnum.DATE,
                                FieldEnum.CAMPAIGN_ID,
                                FieldEnum.CRITERIA_TYPE,
                                FieldEnum.CRITERIA_ID,
                                FieldEnum.COST_PER_CONVERSION },
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT3,
                        new Long[] { 44933891L },
                        "2021-11-07",
                        "2021-11-07",
                        null,
                },
                new Object[] {
                        FieldEnum.CRITERIA_TYPE,
                        (Function<ReportsLine, ?>) ReportsLine::getCriteriaType,
                        new FieldEnum[] { FieldEnum.DATE, FieldEnum.CRITERIA_TYPE },
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT7,
                        new Long[] { 45401838L, 29076966L, 30038263L },
                        "2021-10-06",
                        "2021-11-06",
                        null,
                },
                new Object[] {
                        FieldEnum.GOALS_ROI,
                        (Function<ReportsLine, ?>) ReportsLine::getGoalsRoi,
                        new FieldEnum[] { FieldEnum.DATE, FieldEnum.GOALS_ROI, FieldEnum.CAMPAIGN_ID },
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT3,
                        new Long[] { 44933857L, 44933937L},
                        "2021-10-25",
                        "2021-10-25",
                        new FilterItemMap()
                                .withField(FieldEnum.GOALS_ROI)
                                .withOperator(FilterOperatorEnum.GREATER_THAN)
                                .withValues(0),
                },
                new Object[] {
                        FieldEnum.MONTH,
                        (Function<ReportsLine, ?>) ReportsLine::getMonth,
                        new FieldEnum[] { FieldEnum.MONTH, FieldEnum.AD_GROUP_ID },
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT4,
                        new Long[] { 40693928L, 35057910L },
                        "2021-01-01",
                        "2021-12-31",
                        null,
                },
                new Object[] {
                        FieldEnum.QUARTER,
                        (Function<ReportsLine, ?>) ReportsLine::getQuarter,
                        new FieldEnum[] { FieldEnum.QUARTER, FieldEnum.AD_GROUP_ID, FieldEnum.CAMPAIGN_ID },
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT4,
                        new Long[] { 35058302L },
                        "2020-12-01",
                        "2021-01-30",
                        null,
                },
                new Object[] {
                        FieldEnum.REVENUE,
                        (Function<ReportsLine, ?>) ReportsLine::getRevenue,
                        new FieldEnum[] { FieldEnum.DATE, FieldEnum.REVENUE },
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT3,
                        new Long[] { 44933923L },
                        "2021-11-01",
                        "2021-11-08",
                        new FilterItemMap()
                                .withField(FieldEnum.REVENUE)
                                .withOperator(FilterOperatorEnum.GREATER_THAN)
                                .withValues(0),

                },
                new Object[] {
                        FieldEnum.RL_ADJUSTMENT_ID,
                        (Function<ReportsLine, ?>) ReportsLine::getRlAdjustmentId,
                        new FieldEnum[] { FieldEnum.DATE, FieldEnum.RL_ADJUSTMENT_ID , FieldEnum.CAMPAIGN_ID},
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT13,
                        new Long[] { 15255822L },
                        "2019-09-09",
                        "2019-09-09",
                        null,
                },
                new Object[] {
                        FieldEnum.YEAR,
                        (Function<ReportsLine, ?>) ReportsLine::getYear,
                        new FieldEnum[] { FieldEnum.YEAR, FieldEnum.AD_GROUP_ID, FieldEnum.CAMPAIGN_ID},
                        ReportsLogins.CLIENT_FOR_CRITERIA_PERFORMANCE_REPORT4,
                        new Long[] { 53947587L },
                        "2020-12-31",
                        "2021-01-01",
                        null,
                },
        };

        return Arrays.asList(result);
    }

    @Before
    public void prepare() {
        List<FilterItemMap> filterList = new ArrayList<>();

        filterList.add(new FilterItemMap()
                .withField(FieldEnum.CAMPAIGN_ID)
                .withOperator(FilterOperatorEnum.IN)
                .withValues(campaignIds));

        if (additionalFilter != null) {
            filterList.add(additionalFilter);
        }

        filters = filterList.toArray(new FilterItemMap[0]);

        api.as(Logins.LOGIN_SUPER).clientLogin(login);
    }

    @Test
    public void test() {
        ReportsData report = api.userSteps.reportsSteps().callReportsXml(new ReportDefinitionMap()
                .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.CRITERIA_PERFORMANCE_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(dateFrom)
                        .withDateTo(dateTo)
                        .withFilter(filters))
                .withFieldNames(requestedFieldNames)
                .withOrderBy(new OrderByMap().withField(fieldName))
                .withPage(new PageMap().withLimit(10000L)));

        assumeThat("отчёт не пустой", report.getReportsLines(), not(empty()));

        List<Object> columnData = report.getReportsLines().stream()
                .map(valueGetter)
                .filter(Objects::nonNull)
                .collect(Collectors.toList());

        assumeThat("в отчёте по меньшей мере два разных значения, отличных от null",
                columnData.stream().distinct().collect(Collectors.toList()),
                hasSize(greaterThanOrEqualTo(2)));

        assertThat("значения упорядочены", columnData, OrderMatcher.isAscendingOrdered());
    }

    @Test
    public void testAscending() {
        ReportsData report = api.userSteps.reportsSteps().callReportsXml(new ReportDefinitionMap()
                .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.CRITERIA_PERFORMANCE_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(dateFrom)
                        .withDateTo(dateTo)
                        .withFilter(filters))
                .withFieldNames(requestedFieldNames)
                .withOrderBy(new OrderByMap()
                        .withField(fieldName)
                        .withSortOrder(SortOrderEnum.ASCENDING))
                .withPage(new PageMap().withLimit(10000L)));

        assumeThat("отчёт не пустой", report.getReportsLines(), not(empty()));

        List<Object> columnData = report.getReportsLines().stream()
                .map(valueGetter)
                .filter(Objects::nonNull)
                .collect(Collectors.toList());

        assumeThat("в отчёте по меньшей мере два разных значения, отличных от null",
                columnData.stream().distinct().collect(Collectors.toList()),
                hasSize(greaterThanOrEqualTo(2)));

        assertThat("значения упорядочены", columnData, OrderMatcher.isAscendingOrdered());
    }

    @Test
    public void testDescending() {
        ReportsData report = api.userSteps.reportsSteps().callReportsXml(new ReportDefinitionMap()
                .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.CRITERIA_PERFORMANCE_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(dateFrom)
                        .withDateTo(dateTo)
                        .withFilter(filters))
                .withFieldNames(requestedFieldNames)
                .withOrderBy(new OrderByMap()
                        .withField(fieldName)
                        .withSortOrder(SortOrderEnum.DESCENDING))
                .withPage(new PageMap().withLimit(10000L)));

        assumeThat("отчёт не пустой", report.getReportsLines(), not(empty()));

        List<Object> columnData = report.getReportsLines().stream()
                .map(valueGetter)
                .filter(Objects::nonNull)
                .collect(Collectors.toList());

        assumeThat("в отчёте по меньшей мере два разных значения, отличных от null",
                columnData.stream().distinct().collect(Collectors.toList()),
                hasSize(greaterThanOrEqualTo(2)));

        assertThat("значения упорядочены", columnData, OrderMatcher.isDescendingOrdered());
    }
}
