package ru.yandex.autotests.directapi.reports.customreport;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

/**
 * Created by lightelfik on 24.04.19.
 * https://st.yandex-team.ru/DIRECT-94500
 */
@Aqua.Test
@Description("OFFLINE_CUSTOM_REPORT: проверка получения ошибки при использовании AudienceTargetId с несовместими полями в фильтре")
@Issue("https://st.yandex-team.ru/DIRECT-94500")
@Features(ReportsFeatures.OFFLINE_CUSTOM_REPORT)
public class CustomReportIncompatibleFilterFieldsNegativeTest {
    private static final String CLIENT = ReportsLogins.CLIENT_FOR_CUSTOM_REPORT1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @Test
    public void CriterionTypeWithAudienceTargetIdInFilter() {
        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                new ReportDefinitionMap()
                        .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.CUSTOM_REPORT)
                        .withDateRangeType(DateRangeTypeEnum.TODAY)
                        .withSelectionCriteria(
                                new SelectionCriteriaMap()
                                        .withFilter(
                                                new FilterItemMap()
                                                        .withField(FieldEnum.AUDIENCE_TARGET_ID)
                                                        .withOperator(FilterOperatorEnum.IN)
                                                        .withValues("1"),
                                                new FilterItemMap()
                                                        .withField(FieldEnum.CRITERION_TYPE)
                                                        .withOperator(FilterOperatorEnum.IN)
                                                        .withValues("1"))
                        ),
                new Api5Error(4001, Api5ErrorDetails.ONLY_ONE_OF_THE_CRITERIA_TYPE)
        );
    }
}
