package ru.yandex.autotests.directapi.reports.customreport;

import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by gerdler on 07.12.16.
 * https://st.yandex-team.ru/TESTIRT-10479
 */
@Aqua.Test
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@Description("Проверка ответа сервиса при запросе отчета за период выходящий за пределы окна и за период включающий границу окна")
@Issue("https://st.yandex-team.ru/DIRECT-56778")
public class CustomReportSlidingWindowTest {
    public static Integer currentMonth = DateTime.now().getMonthOfYear();
    public static Integer currentYear = DateTime.now().getYear();
    public static DateTime validBoundaryDay = DateTime.now().withDate(currentYear - 3, currentMonth, 1);
    public static DateTime invalidBoundaryDay = validBoundaryDay.minusDays(1);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN).clientLogin(ReportsLogins.REPORT_CLIENT_FOR_SLIDING_WINDOW);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    public void successGetReportForPeriodThreeYearsAgo() {
        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(
                new ReportDefinitionMap()
                        .withDefaultCustomReportWithUniqueReportName()
                        .withCustomDates(validBoundaryDay, validBoundaryDay)
        );
        assertThat("отчет получен", reportsData, notNullValue());
    }

    @Test
    public void successGetReportForPeriodWithStartDateEarlyThanThreeYearsAgo() {
        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(
                new ReportDefinitionMap()
                        .withDefaultCustomReportWithUniqueReportName()
                        .withCustomDates(invalidBoundaryDay, validBoundaryDay)
        );
        assertThat("отчет получен", reportsData, notNullValue());
    }

    @Test
    public void tryGetReportForPeriodEarlyThanThreeYearsAgo() {
        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                new ReportDefinitionMap()
                        .withDefaultCustomReportWithUniqueReportName()
                        .withCustomDates(invalidBoundaryDay, invalidBoundaryDay),
                new Api5Error(
                        4001,
                        Api5ErrorDetails.REPORTS_DATE_RANGE_OUT_OF_SLIDING_WINDOW,
                        ReportTypeEnum.CUSTOM_REPORT,
                        capitalize(SelectionCriteriaMap.DATE_TO),
                        validBoundaryDay.toString(ReportsData.DATE_FORMAT)
                )
        );
    }

    @Test
    public void compareReportsDataForPeriodThreeYearsAgo() {
        DateTime dateFrom = validBoundaryDay.minusMonths(1);
        DateTime dateTo = validBoundaryDay.plusMonths(1);
        ReportsData expectedReportsData = api.userSteps.reportsSteps().callReportsXml(
                new ReportDefinitionMap()
                        .withDefaultCustomReportWithUniqueReportName()
                        .withCustomDates(validBoundaryDay, dateTo)
                        .withFieldNames(FieldEnum.CLICKS, FieldEnum.IMPRESSIONS)
        );
        assumeThat("вернулся непустой отчет", expectedReportsData.getReportsLines(), not(empty()));
        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(
                new ReportDefinitionMap()
                        .withDefaultCustomReportWithUniqueReportName()
                        .withCustomDates(dateFrom, dateTo)
                        .withFieldNames(FieldEnum.CLICKS, FieldEnum.IMPRESSIONS)
        );
        assertThat("получили правильные данные", reportsData.getReportsLines(), beanDiffer(expectedReportsData.getReportsLines()));
    }
}
