package ru.yandex.autotests.directapi.reports.daterange;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 9/28/16.
 * https://st.yandex-team.ru/TESTIRT-9722
 */
@Aqua.Test
@Description("Проверка того, что возвращается нужное количество кампаний за период в прошлом")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class DateRangeCampaignsCountTest {
    private static final String CLIENT = ReportsLogins.CLIENT_RUB_WITH_STAT2;
    private static final int NUMBER_OF_CAMPAIGNS = 6;
    private static final String CUSTOM_DATE1 = "2019-07-02";
    private static final String CUSTOM_DATE2 = "2019-09-02";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    public void checkInsidesCustomDate() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withFieldNames(FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(CUSTOM_DATE1)
                        .withDateTo(CUSTOM_DATE2))
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);

        assertThat("в отчете отображается верное количество компаний", reportsData.getReportsLines().size(),
                equalTo(NUMBER_OF_CAMPAIGNS));
    }
}
