package ru.yandex.autotests.directapi.reports.daterange;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsLine;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestStepsEn.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestStepsEn.assumeThat;

/**
 * Created by onotole on 21.07.16.
 * https://st.yandex-team.ru/TESTIRT-9722
 */
@Aqua.Test
@Description("Расширенная проверка репорта для произвольных дат (custom date)")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class DateRangeExtendedCustomDateTest {
    private static final String CLIENT = ReportsLogins.CLIENT_FOR_DATE_RANGE_EXTENDED;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String dateFrom;

    @Parameterized.Parameter(1)
    public String dateTo;

    @Parameterized.Parameter(2)
    public FieldEnum fieldPeriodType;

    @Parameterized.Parameter(3)
    public int expectedCountOfPeriods;

    @Parameterized.Parameters(name = "{0} {1} {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][] {
                {"2020-03-08", "2021-09-08", FieldEnum.YEAR, 2},
                {"2020-09-08", "2021-09-08", FieldEnum.QUARTER, 5},
                {"2020-08-08", "2021-08-08", FieldEnum.MONTH, 13},
                {"2020-08-08", "2021-08-08", FieldEnum.WEEK, 51},
                {"2020-08-08", "2021-08-08", FieldEnum.DATE, 257},

                {"2021-03-08", "2021-09-08", FieldEnum.YEAR, 1},
                {"2021-07-08", "2021-09-08", FieldEnum.QUARTER, 1},
                {"2021-09-01", "2021-09-08", FieldEnum.MONTH, 1},
                {"2021-08-05", "2021-08-08", FieldEnum.WEEK, 1},
                {"2021-09-02", "2021-09-02", FieldEnum.DATE, 1},
        });
    }

    @Test
    public void extendedCustomDate() {
        String currentDate;
        Boolean isBorderNotBroken = true;

        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withFieldNames(fieldPeriodType)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(dateFrom)
                        .withDateTo(dateTo))
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assumeThat("вернулось нужно количество строк в репорте", reportsData.getReportsLines().size(), equalTo(expectedCountOfPeriods));

        for (int i = 1; i < reportsData.getReportsLines().size(); i++) {
            currentDate = getDate(reportsData.getReportsLines().get(i));
            // не нарушены ли границы
            if ( currentDate.compareTo(dateFrom) < 0 || dateTo.compareTo(currentDate) < 0) {
                isBorderNotBroken = false;
                break;
            }
        }
        assertThat("Даты из репорта не вышли за границы запрашиваемого диапазона", isBorderNotBroken, equalTo(true));

    }

    private String getDate(ReportsLine reportsLine) {
        String result = "";
        switch(fieldPeriodType) {
            case DATE:
                result = reportsLine.getDate();
                break;
            case YEAR:
                result = reportsLine.getYear();
                break;
            case QUARTER:
                result = reportsLine.getQuarter();
                break;
            case MONTH:
                result = reportsLine.getMonth();
                break;
            case WEEK:
                result = reportsLine.getWeek();
                break;
        }
        return result;
    }
}
