package ru.yandex.autotests.directapi.reports.daterange;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsLine;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 10/5/16.
 * https://st.yandex-team.ru/TESTIRT-9722
 */
@Aqua.Test
@Description("Расширенная проверка репорта для произвольных дат (проверка, что возвращаются правильные даты для YEAR, MONTH, WEEK)")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class DateRangeExtendedFirstDayOfPeriodTest {
    private static final String CLIENT = ReportsLogins.CLIENT_RUB_WITH_STAT2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String dateFrom;

    @Parameterized.Parameter(1)
    public String dateTo;

    @Parameterized.Parameter(2)
    public FieldEnum fieldPeriodType;

    @Parameterized.Parameter(3)
    public String[] expectedDates;

    @Parameterized.Parameters(name = "{0} {1} {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][] {
                {"2021-02-23", "2022-01-10", FieldEnum.YEAR, new String[] {"2021-02-23", "2022-01-01"}},
                {"2021-02-08", "2021-09-08", FieldEnum.QUARTER, new String[] {"2021-02-08", "2021-04-01", "2021-07-01"}},
                {"2021-07-08", "2021-09-08", FieldEnum.MONTH, new String[] {"2021-07-08", "2021-08-01", "2021-09-01"}},
                {"2021-09-07", "2021-09-21", FieldEnum.WEEK, new String[] {"2021-09-07", "2021-09-13", "2021-09-20"}},
        });
    }

    @Test
    public void checkDayOfPeriod() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withFieldNames(fieldPeriodType)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(dateFrom)
                        .withDateTo(dateTo))
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE);
        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        String[] dates = getDatesArray(reportsData.getReportsLines(), fieldPeriodType);
        assertThat("Вернулись ожидаемые даты", dates, equalTo(expectedDates));
    }


    private String[] getDatesArray(List<ReportsLine> reportLines, FieldEnum field) {
        switch (field) {
            case WEEK:
                return reportLines.stream().map(ReportsLine::getWeek).toArray(String[]::new);
            case MONTH:
                return reportLines.stream().map(ReportsLine::getMonth).toArray(String[]::new);
            case QUARTER:
                return reportLines.stream().map(ReportsLine::getQuarter).toArray(String[]::new);
            case YEAR:
                return reportLines.stream().map(ReportsLine::getYear).toArray(String[]::new);
            default:
                return reportLines.stream().map(ReportsLine::getDate).toArray(String[]::new);
        }
    }

}
