package ru.yandex.autotests.directapi.reports.daterange;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 9/28/16.
 * https://st.yandex-team.ru/TESTIRT-9689
 */
@Aqua.Test
@Description("Проверка поведения для различных значений DateRangeType (произвольные даты)")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class DateValidationCustomRangeTest {
    private static final String CLIENT = ReportsLogins.CLIENT_RUB_WITH_STAT2;

    private final String customDate1 = "2019-11-23";
    private final String customDate2 = "2019-12-08";
    private final DateTime customDate1DateTime = DateTime.parse(customDate1);
    private final DateTime customDate2DateTime = DateTime.parse(customDate2);

    private final String customDate1Str = customDate1DateTime.toString(ReportsData.DATE_FORMAT);
    private final String customDate2Str = customDate2DateTime.toString(ReportsData.DATE_FORMAT);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    public void checkTitleForCustomDate() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withFieldNames(FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(customDate1)
                        .withDateTo(customDate2))
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        String actualReportName = reportsData.getReportHeader();

        String expectedReportName = String.format(ReportsData.REPORT_NAME_FORMAT, reportDefinitionMap.getReportName(), customDate1Str, customDate2Str);
        assertThat("даты отчета за заданный интервал дат вернулись верные", actualReportName, equalTo(expectedReportName));
    }
}
