package ru.yandex.autotests.directapi.reports.daterange;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 06.07.16.
 * https://st.yandex-team.ru/TESTIRT-9689
 */
@Aqua.Test
@Description("Проверка поведения для различных значений DateRangeType (последние N дней)")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class DateValidationLastNDaysRangeTest {
    private static final String CLIENT = ReportsLogins.CLIENT_FOR_DATE_VALIDATION_LAST_N_DAYS;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public DateRangeTypeEnum dateRangeTypeEnum;

    @Parameterized.Parameter(1)
    public int lengthOfPeriodInDays;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {DateRangeTypeEnum.LAST_3_DAYS, 3},
                {DateRangeTypeEnum.LAST_5_DAYS, 5},
                {DateRangeTypeEnum.LAST_7_DAYS, 7},
                {DateRangeTypeEnum.LAST_14_DAYS, 14},
                {DateRangeTypeEnum.LAST_30_DAYS, 30},
                {DateRangeTypeEnum.LAST_90_DAYS, 90},
                {DateRangeTypeEnum.LAST_365_DAYS, 365},
                {DateRangeTypeEnum.YESTERDAY, 1},
        });
    }

    @Test
    public void test() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withFieldNames(FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO)
                .withSelectionCriteria(new SelectionCriteriaMap())
                .withDateRangeType(dateRangeTypeEnum);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        String actualReportName = reportsData.getReportHeader();

        DateTime todayDateRaw = DateTime.now();
        DateTime yesterdayRaw = todayDateRaw.minusDays(1);
        DateTime secondDateRaw = todayDateRaw.minusDays(lengthOfPeriodInDays);
        String yesterday = yesterdayRaw.toString(ReportsData.DATE_FORMAT);
        String secondDate = secondDateRaw.toString(ReportsData.DATE_FORMAT);

        String expectedReportName = String.format(ReportsData.REPORT_NAME_FORMAT, reportDefinitionMap.getReportName(), secondDate, yesterday);
        assertThat("даты отчета вернулись верные", actualReportName, equalTo(expectedReportName));
    }
}
