package ru.yandex.autotests.directapi.reports.fieldnames;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsLine;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.math.BigDecimal.ROUND_HALF_UP;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 7/27/16.
 * https://st.yandex-team.ru/TESTIRT-9733
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Description("Проверяем, что верно получены вычисляемы поля в отчете")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class CalculableFieldsTest {
    private static final String CLIENT = ReportsLogins.CLIENT_WITH_STAT_WITH_ALL_TYPE_ADS;
    private static BigDecimal revenue;
    private static BigDecimal cost;
    private static BigDecimal goalsRoi;
    private static BigDecimal ctr;
    private static int impressions;
    private static int clicks;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final FieldEnum[] FIELDS = new FieldEnum[]{
            FieldEnum.CONVERSIONS,
            FieldEnum.CONVERSION_RATE,
            FieldEnum.CLICKS,
            FieldEnum.IMPRESSIONS,
            FieldEnum.AVG_CLICK_POSITION,
            FieldEnum.AVG_IMPRESSION_POSITION,
            FieldEnum.CTR,
            FieldEnum.REVENUE,
            FieldEnum.COST,
            FieldEnum.GOALS_ROI,
    };

    @BeforeClass
    public static void beforeClass() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withFieldNames(FIELDS)
                .withCustomDates("2019-09-01", "2019-11-30")
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);
        ReportsData reportsData = api.returnMoneyInMicros(true).userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assumeThat("вернулся репорт с как минимум одной строкой", reportsData.getReportsLines().size(), greaterThan(0));
        ReportsLine reportsLine = reportsData.getReportsLines().get(0);
        revenue = reportsLine.getRevenue();
        cost = reportsLine.getCost();
        goalsRoi = reportsLine.getGoalsRoi();
        clicks = reportsLine.getClicks();
        impressions = reportsLine.getImpressions();
        ctr = reportsLine.getCtr();
    }

    @Test
    public void checkGoalsRoi(){
        BigDecimal goalsRoiExpected = revenue.subtract(cost).divide(cost, 2, ROUND_HALF_UP);
        assertThat("goalsRoi посчитался верно", goalsRoiExpected, equalTo(goalsRoi));
    }

    @Test
    public void checkCtr() {
        BigDecimal ctrExpected = new BigDecimal(clicks).multiply(new BigDecimal(100)).divide(new BigDecimal(impressions), 2, ROUND_HALF_UP);
        assertThat("CTR посчитан верно", ctrExpected, equalTo(ctr));
    }
}
