package ru.yandex.autotests.directapi.reports.fieldnames;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 05.07.16.
 * https://st.yandex-team.ru/TESTIRT-9682
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Description("Проверяем, что колонки в ответе соответствуют полям, указанным в FieldNames")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class FieldNamesFieldsValidationTest {
    public static final String LOGIN = ReportsLogins.CLIENT_FOR_FIELD_NAMES_VALIDATION;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FieldEnum fieldName;

    @Parameterized.Parameters(name = "FieldName = {0}")
    public static Iterable<Object[]> fieldNameValues() {
        Set<FieldEnum> skipFields = EnumSet.of(
                FieldEnum.AUDIENCE_TARGET_ID,
                FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID,
                FieldEnum.IMPRESSION_SHARE,
                FieldEnum.KEYWORD,
                FieldEnum.MATCHED_KEYWORD,
                FieldEnum.QUERY,
                FieldEnum.SMART_BANNER_FILTER_ID,
                FieldEnum.SMART_AD_TARGET_ID,
                FieldEnum.AVG_CPM,
                FieldEnum.AVG_IMPRESSION_FREQUENCY,
                FieldEnum.IMPRESSION_REACH);

        return Stream.of(FieldEnum.values())
                .filter(field -> !skipFields.contains(field))
                .map(x -> new Object[]{x})
                .collect(Collectors.toList());
    }

    @Test
    public void testFieldNames() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap())
                .withFieldNames(fieldName)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.LAST_MONTH)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);

        assertThat("имя колонки " + fieldName.toString() + " верно отображается в отчете",
                reportsData.getColumnsHeaders(), equalTo(fieldName.value()));

    }
}