package ru.yandex.autotests.directapi.reports.fieldnames;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 07.07.16.
 * https://st.yandex-team.ru/TESTIRT-9682
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Description("Проверяем, что колонки в ответе соответствуют полям, указанным в FieldNames. Проверка для нескольких полей")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class FieldNamesMultipleNamesValidationTest {
    public static final String LOGIN = ReportsLogins.REPORTS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();


    @Test
    public void test2FieldNames() {
        FieldEnum field1 = FieldEnum.DATE, field2 = FieldEnum.CAMPAIGN_ID;
        String fieldName1 = field1.value(), fieldName2 = field2.value();

        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap())
                .withFieldNames(field1, field2)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.LAST_MONTH)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);

        assertThat(String.format("имена колонок %s и %s верно отображаются в отчете", fieldName1, fieldName2),
                reportsData.getColumnsHeaders(), equalTo(String.format("%s\t%s", fieldName1, fieldName2)));
    }

    @Test
    public void testManyFieldNames() {

        FieldEnum[] fieldEnums = {
                FieldEnum.AD_GROUP_ID,
                FieldEnum.AD_GROUP_NAME,
                FieldEnum.AD_ID,
                FieldEnum.AD_NETWORK_TYPE,
                FieldEnum.AGE,
                FieldEnum.AVG_CPC,
                FieldEnum.AVG_CLICK_POSITION,
                FieldEnum.COST_PER_CONVERSION ,
                FieldEnum.AVG_IMPRESSION_POSITION,
                FieldEnum.AVG_PAGEVIEWS ,
                FieldEnum.BOUNCE_RATE,
                FieldEnum.BOUNCES,
                FieldEnum.CAMPAIGN_ID,
                FieldEnum.CAMPAIGN_NAME,
                FieldEnum.CAMPAIGN_TYPE,
                FieldEnum.CARRIER_TYPE,
                FieldEnum.CLICKS,
                FieldEnum.CONVERSIONS,
                FieldEnum.CONVERSION_RATE,
                FieldEnum.COST,
                FieldEnum.CRITERIA,
                FieldEnum.CRITERIA_ID,
                FieldEnum.CRITERIA_TYPE,
                FieldEnum.CTR,
                FieldEnum.DATE,
                FieldEnum.DEVICE,
                FieldEnum.EXTERNAL_NETWORK_NAME,
                FieldEnum.GENDER,
                FieldEnum.GOALS_ROI,
                FieldEnum.AD_FORMAT,
                FieldEnum.IMPRESSIONS,
                FieldEnum.LOCATION_OF_PRESENCE_ID,
                FieldEnum.LOCATION_OF_PRESENCE_NAME,
                FieldEnum.MOBILE_PLATFORM,
                FieldEnum.REVENUE,
                FieldEnum.SLOT,
                FieldEnum.TARGETING_LOCATION_ID,
                FieldEnum.TARGETING_LOCATION_NAME,
                FieldEnum.PLACEMENT,
        };

        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap())
                .withUniqueReportName()
                .withFieldNames(fieldEnums)
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.LAST_MONTH)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);

        String expectedColumnNames = Stream.of(fieldEnums).map(FieldEnum::value).collect(Collectors.joining("\t"));

        assertThat("имена всех колонок верно отображается в отчете",
                reportsData.getColumnsHeaders(), equalTo(expectedColumnNames));
    }

    @Test
    @Description("case for bug DIRECT-56091")
    public void checkReportNameInDifficultCase() {
         api.as("at-intapi-test");

         ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                 .withDefaultCustomReportWithUniqueReportName()
                 .withSelectionCriteria(
                         new SelectionCriteriaMap()
                 )
                 .withUniqueReportName()
                 .withDateRangeType(DateRangeTypeEnum.LAST_7_DAYS);

         String yesterday = DateTime.now().minusDays(1).toString(ReportsData.DATE_FORMAT);
         String weekAgo = DateTime.now().minusWeeks(1).toString(ReportsData.DATE_FORMAT);
         ReportsData data = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
         String expectedReportName = String.format(ReportsData.REPORT_NAME_FORMAT, reportDefinitionMap.getReportName(), weekAgo, yesterday);
         assertThat("вернулось правильное имя отчета", data.getReportHeader(), equalTo(expectedReportName));

    }


}
