package ru.yandex.autotests.directapi.reports.fieldnames;

import com.yandex.direct.api.v5.reports.FieldEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsLine;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 01.12.16.
 * https://st.yandex-team.ru/TESTIRT-10690
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-61232")
@Description("Проверяем, что в поле Sessions для РМП-кампаний получаем количество кликов")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class SessionsInMobileAppCampaign {
    private static final String CLIENT = ReportsLogins.CLIENT_WITH_MOBILE_CONTENT;
    private static final String DATE_FROM = "2020-11-01";
    private static final String DATE_TO = "2020-11-20";
    private static final Long CAMPAIGN_ID = 30493570L;
    private static final Integer EXPECTED_CLICKS = 543;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    public void checkSessionsInMobileAppCampaign() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withCustomDatesAndCampaignIds(DATE_FROM, DATE_TO, CAMPAIGN_ID)
                .withFieldNames(FieldEnum.SESSIONS, FieldEnum.CLICKS);
        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assumeThat("вернулся непустой отчет", reportsData.getReportsLines(), not(empty()));
        ReportsLine reportsLine = reportsData.getReportsLines().get(0);
        assumeThat("вернулось правильное значение в поле Clicks", reportsLine.getClicks(), equalTo(EXPECTED_CLICKS));
        assertThat("вернулось правильное значение в поле Sessions", reportsLine.getSessions(), equalTo(reportsLine.getClicks()));
    }
}
