package ru.yandex.autotests.directapi.reports.filter;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.GenderEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.CampaignTypeEnum;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 15.07.16.
 * https://st.yandex-team.ru/TESTIRT-9704
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Description("проверка работы Filter, проверка всех возможных значений для фильтрации")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class AllFilterFieldsTest {

    public static final String CLIENT = ReportsLogins.AUDIENCE_TARGET_ID_CLIENT;
    // при группировке по одному, числому полю в отчете всегда не более одной строки.
    // для не числовых используется EQUALS
    private final static int ROW_COUNT = 1;
    private final static String DATE_TO = "2019-10-02";
    private final static String DATE_FROM = "2019-10-01";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FieldEnum filterField;

    @Parameterized.Parameter(1)
    public FilterOperatorEnum filterOperator;

    @Parameterized.Parameter(2)
    public String filterValue;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data () {
        return Arrays.asList(new Object[][]{
                {FieldEnum.AD_FORMAT, FilterOperatorEnum.EQUALS, "TEXT"},
                {FieldEnum.AD_GROUP_ID, FilterOperatorEnum.EQUALS, "130287166"},
                {FieldEnum.AD_NETWORK_TYPE, FilterOperatorEnum.EQUALS, "SEARCH"},
                {FieldEnum.AGE, FilterOperatorEnum.EQUALS, AgeRangeEnum.AGE_18_24.value()},
                {FieldEnum.AVG_CPC, FilterOperatorEnum.GREATER_THAN, "100000"},
                {FieldEnum.AVG_CLICK_POSITION, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.COST_PER_CONVERSION , FilterOperatorEnum.GREATER_THAN, "100000"},
                {FieldEnum.AVG_IMPRESSION_POSITION, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.AVG_PAGEVIEWS , FilterOperatorEnum.GREATER_THAN, "4"},
                {FieldEnum.AVG_TRAFFIC_VOLUME, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.BOUNCE_RATE, FilterOperatorEnum.GREATER_THAN, "0"},
                {FieldEnum.CAMPAIGN_ID, FilterOperatorEnum.EQUALS, "22894590"},
                {FieldEnum.CARRIER_TYPE, FilterOperatorEnum.EQUALS, "CELLULAR"},
                {FieldEnum.CLICKS, FilterOperatorEnum.GREATER_THAN, "2"},
                {FieldEnum.CLICK_TYPE, FilterOperatorEnum.EQUALS, "SITELINK1"},
                {FieldEnum.CONVERSIONS, FilterOperatorEnum.GREATER_THAN, "2"},
                {FieldEnum.CONVERSION_RATE, FilterOperatorEnum.GREATER_THAN, "20"},
                {FieldEnum.COST, FilterOperatorEnum.GREATER_THAN, "10000000"},
                {FieldEnum.CRITERIA_TYPE, FilterOperatorEnum.EQUALS, "KEYWORD"},
                {FieldEnum.CRITERION_TYPE, FilterOperatorEnum.EQUALS, "KEYWORD"},
                {FieldEnum.CTR, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.WEIGHTED_CTR, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.WEIGHTED_IMPRESSIONS, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.DEVICE, FilterOperatorEnum.EQUALS, "DESKTOP"},
                {FieldEnum.EXTERNAL_NETWORK_NAME, FilterOperatorEnum.EQUALS, "Yandex and YAN"},
                {FieldEnum.GENDER, FilterOperatorEnum.EQUALS, GenderEnum.GENDER_MALE.value()},
                {FieldEnum.IMPRESSIONS, FilterOperatorEnum.GREATER_THAN, "4000"},
                {FieldEnum.LOCATION_OF_PRESENCE_ID, FilterOperatorEnum.EQUALS, "35"},
                {FieldEnum.MATCH_TYPE, FilterOperatorEnum.EQUALS, "SYNONYM"},
                {FieldEnum.MOBILE_PLATFORM, FilterOperatorEnum.EQUALS, "IOS"},
                {FieldEnum.PLACEMENT, FilterOperatorEnum.EQUALS, "maps.yandex.ru"},
                {FieldEnum.PROFIT, FilterOperatorEnum.LESS_THAN, "100000"},
                {FieldEnum.SLOT, FilterOperatorEnum.EQUALS, "PREMIUMBLOCK"},
                {FieldEnum.TARGETING_LOCATION_ID, FilterOperatorEnum.EQUALS, "10987"},
                {FieldEnum.CAMPAIGN_TYPE, FilterOperatorEnum.EQUALS, CampaignTypeEnum.TEXT_CAMPAIGN.value()},
                {FieldEnum.TARGETING_CATEGORY, FilterOperatorEnum.EQUALS, "UNKNOWN"},
                {FieldEnum.INCOME_GRADE, FilterOperatorEnum.EQUALS, "OTHER"}
        });
    }

    @Test
    public void testFilterByField() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateTo(DATE_TO)
                        .withDateFrom(DATE_FROM)
                        .withFilter(new FilterItemMap()
                                .withField(filterField)
                                .withOperator(filterOperator)
                                .withValues(filterValue)))
                .withFieldNames(filterField)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("фильтрация по полю " + filterOperator + " отработала успешно", reportsData.getReportsLines().size(),
                equalTo(ROW_COUNT));
    }

}
