package ru.yandex.autotests.directapi.reports.filter;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 2/28/17.
 */
@Aqua.Test
@Description("Проверка работы дробных полей с операторами EQUALS и IN")
@Issue("https://st.yandex-team.ru/DIRECT-62154")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class FilterByFractionalFieldsNegativeTest {
    public static final String CLIENT = ReportsLogins.CLIENT_EUR_WITH_STAT;
    private final static String DATE = "2021-09-01";
    private final static Long ANY_VALUE = 3000000L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FieldEnum field;

    @Parameterized.Parameter(1)
    public FilterOperatorEnum operator;

    @Parameterized.Parameters(name = "field {0}, operator {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {FieldEnum.AVG_CLICK_POSITION, FilterOperatorEnum.EQUALS},
                {FieldEnum.AVG_CLICK_POSITION, FilterOperatorEnum.IN},
                {FieldEnum.AVG_CPC, FilterOperatorEnum.EQUALS},
                {FieldEnum.AVG_CPC, FilterOperatorEnum.IN},
                {FieldEnum.AVG_IMPRESSION_POSITION, FilterOperatorEnum.EQUALS},
                {FieldEnum.AVG_IMPRESSION_POSITION, FilterOperatorEnum.IN},
                {FieldEnum.AVG_PAGEVIEWS, FilterOperatorEnum.EQUALS},
                {FieldEnum.AVG_PAGEVIEWS, FilterOperatorEnum.IN},
                {FieldEnum.BOUNCE_RATE, FilterOperatorEnum.EQUALS},
                {FieldEnum.BOUNCE_RATE, FilterOperatorEnum.IN},
                {FieldEnum.CONVERSION_RATE, FilterOperatorEnum.EQUALS},
                {FieldEnum.CONVERSION_RATE, FilterOperatorEnum.IN},
                {FieldEnum.COST, FilterOperatorEnum.EQUALS},
                {FieldEnum.COST, FilterOperatorEnum.IN},
                {FieldEnum.COST_PER_CONVERSION, FilterOperatorEnum.EQUALS},
                {FieldEnum.COST_PER_CONVERSION, FilterOperatorEnum.IN},
                {FieldEnum.CTR, FilterOperatorEnum.EQUALS},
                {FieldEnum.CTR, FilterOperatorEnum.IN},
                {FieldEnum.GOALS_ROI, FilterOperatorEnum.EQUALS},
                {FieldEnum.GOALS_ROI, FilterOperatorEnum.IN},
                {FieldEnum.PROFIT, FilterOperatorEnum.EQUALS},
                {FieldEnum.PROFIT, FilterOperatorEnum.IN},
                {FieldEnum.REVENUE, FilterOperatorEnum.EQUALS},
                {FieldEnum.REVENUE, FilterOperatorEnum.IN},
        };
        return Arrays.asList(data);
    }

    @Test
    public void tryCreateReportWithInvalidOperatorsForFields() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateTo(DATE)
                        .withDateFrom(DATE)
                        .withFilter(new FilterItemMap()
                                        .withField(field)
                                        .withOperator(operator)
                                        .withValues(ANY_VALUE))
                )
                .withFieldNames(FieldEnum.AGE, FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);
        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap, CLIENT,
                new Api5Error(4001, Api5ErrorDetails.ALLOWED_TO_FILTER_ONLY_OPERATORS_EQUALS_AND_IN, field.value()));
    }

}
