package ru.yandex.autotests.directapi.reports.filter;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by gerdler on 18.10.16.
 * https://st.yandex-team.ru/TESTIRT-10402
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-56047")
@Description("проверка неполучения статистики по чужим кампаниям без получения ошибки")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class FilterByInaccessibleCampaignId {

    private final static String DATE_FROM = "2021-01-01";
    private final static String DATE_TO = "2021-05-30";

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String operatorLogin;

    @Parameterized.Parameter(1)
    public String clientLogin;

    @Parameterized.Parameter(2)
    public Long campaignId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data () {
        return Arrays.asList(new Object[][]{
                {"nazareno-sergei", null, 20000777L}, // клиент запрашивает статистику для кампании другого клиента
                {"click-direct", "a10it-ru", 33573702L}, // агентство от имени одного своего клиента запрашивает статистику по кампании другого своего клиента
        });
    }

    @Test
    public void testFilterByField() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(DATE_FROM)
                        .withDateTo(DATE_TO)
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.CAMPAIGN_ID)
                                .withOperator(FilterOperatorEnum.IN)
                                .withValues(campaignId)))
                .withFieldNames(FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        ReportsData reportsData = api.as(ReportsLogins.SUPER_READER, operatorLogin).userSteps.reportsSteps().callReportsXml(reportDefinitionMap, clientLogin);
        assertThat("получили пустой отчет", reportsData.getReportsLines(), empty());
    }

}
