package ru.yandex.autotests.directapi.reports.filter;

import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.GenderEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.CampaignTypeEnum;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 15.07.16.
 * https://st.yandex-team.ru/TESTIRT-9704
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Description("проверка работы Filter, проверка фильтрации по нескольким полям")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class FilterByManyFieldsTest {
    public static final String CLIENT = ReportsLogins.CLIENT_EUR_WITH_STAT;
    private static final String DATE_TO = "2021-05-01";
    private static final String DATE_FROM = "2021-01-01";

    private static final String TOTAL_ROWS = "Total rows: ";

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    public void testTwoFieldFilter() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateTo(DATE_TO)
                        .withDateFrom(DATE_FROM)
                        .withFilter(new FilterItemMap()
                                        .withField(FieldEnum.AGE)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(AgeRangeEnum.AGE_18_24.value()),
                                new FilterItemMap()
                                        .withField(FieldEnum.CRITERIA_TYPE)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(FieldEnum.KEYWORD.toString()))
                )
                .withFieldNames(FieldEnum.AGE, FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);
        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("фильтрация по двум полям работает", reportsData.getReportsLines().size(), greaterThan(100));
    }

    @Test
    public void testTwoEqualFieldFilter() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateTo(DATE_TO)
                        .withDateFrom(DATE_FROM)
                        .withFilter(
                                new FilterItemMap()
                                        .withField(FieldEnum.CTR)
                                        .withOperator(FilterOperatorEnum.LESS_THAN)
                                        .withValues("10.0"),
                                new FilterItemMap()
                                        .withField(FieldEnum.CTR)
                                        .withOperator(FilterOperatorEnum.GREATER_THAN)
                                        .withValues("10.0"))
                )
                .withFieldNames(FieldEnum.CTR, FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);
        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap, new Api5Error(4001, Api5ErrorDetails.ALLOW_ONLY_ONE_FILTER, "Ctr"));
    }

    @Test
    public void testTwoEqualEnumFieldFilter() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateTo(DATE_TO)
                        .withDateFrom(DATE_FROM)
                        .withFilter(
                                new FilterItemMap()
                                        .withField(FieldEnum.AGE)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(AgeRangeEnum.AGE_0_17.value()),
                                new FilterItemMap()
                                        .withField(FieldEnum.AGE)
                                        .withOperator(FilterOperatorEnum.NOT_EQUALS)
                                        .withValues(AgeRangeEnum.AGE_18_24.value()))
                )
                .withFieldNames(FieldEnum.AGE, FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);
        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap, new Api5Error(4001, Api5ErrorDetails.ALLOW_ONLY_ONE_FILTER, "Age"));
    }


    @Test
    public void testManyFieldFilter() {

        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateTo(DATE_TO)
                        .withDateFrom(DATE_FROM)
                        .withFilter(
                                new FilterItemMap()
                                        .withField(FieldEnum.AD_GROUP_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("2705198980"),
                                new FilterItemMap()
                                        .withField(FieldEnum.AGE)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(AgeRangeEnum.AGE_25_34.value()),
                                new FilterItemMap()
                                        .withField(FieldEnum.AVG_CPC)
                                        .withOperator(FilterOperatorEnum.GREATER_THAN)
                                        .withValues("1000"),
                                new FilterItemMap()
                                        .withField(FieldEnum.AVG_CLICK_POSITION)
                                        .withOperator(FilterOperatorEnum.LESS_THAN)
                                        .withValues("0.5"),
                                new FilterItemMap()
                                        .withField(FieldEnum.COST_PER_CONVERSION )
                                        .withOperator(FilterOperatorEnum.GREATER_THAN)
                                        .withValues("1000"),
                                new FilterItemMap()
                                        .withField(FieldEnum.AVG_PAGEVIEWS )
                                        .withOperator(FilterOperatorEnum.GREATER_THAN)
                                        .withValues("1"),
                                new FilterItemMap()
                                        .withField(FieldEnum.CAMPAIGN_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("27712252"),
                                new FilterItemMap()
                                        .withField(FieldEnum.CARRIER_TYPE)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("STATIONARY"),
                                new FilterItemMap()
                                        .withField(FieldEnum.CLICKS)
                                        .withOperator(FilterOperatorEnum.GREATER_THAN)
                                        .withValues("1"),
                                new FilterItemMap()
                                        .withField(FieldEnum.CONVERSIONS)
                                        .withOperator(FilterOperatorEnum.GREATER_THAN)
                                        .withValues("1"),
                                new FilterItemMap()
                                        .withField(FieldEnum.CONVERSION_RATE)
                                        .withOperator(FilterOperatorEnum.GREATER_THAN)
                                        .withValues("10"),
                                new FilterItemMap()
                                        .withField(FieldEnum.COST)
                                        .withOperator(FilterOperatorEnum.GREATER_THAN)
                                        .withValues("10000"),
                                new FilterItemMap()
                                        .withField(FieldEnum.CRITERIA_TYPE)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("KEYWORD"),
                                new FilterItemMap()
                                        .withField(FieldEnum.CTR)
                                        .withOperator(FilterOperatorEnum.LESS_THAN)
                                        .withValues("50"),
                                new FilterItemMap()
                                        .withField(FieldEnum.DEVICE)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("DESKTOP"),
                                new FilterItemMap()
                                        .withField(FieldEnum.EXTERNAL_NETWORK_NAME)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("Yandex and YAN"),
                                new FilterItemMap()
                                        .withField(FieldEnum.GENDER)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(GenderEnum.GENDER_FEMALE.value()),
                                new FilterItemMap()
                                        .withField(FieldEnum.PROFIT)
                                        .withOperator(FilterOperatorEnum.LESS_THAN)
                                        .withValues("1000000"),
                                new FilterItemMap()
                                        .withField(FieldEnum.REVENUE)
                                        .withOperator(FilterOperatorEnum.LESS_THAN)
                                        .withValues("1000"),
                                new FilterItemMap()
                                        .withField(FieldEnum.AD_FORMAT)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("TEXT"),
                                new FilterItemMap()
                                        .withField(FieldEnum.IMPRESSIONS)
                                        .withOperator(FilterOperatorEnum.GREATER_THAN)
                                        .withValues("100"),
                                new FilterItemMap()
                                        .withField(FieldEnum.LOCATION_OF_PRESENCE_ID)
                                        .withOperator(FilterOperatorEnum.NOT_EQUALS)
                                        .withValues("43"),
                                new FilterItemMap()
                                        .withField(FieldEnum.MOBILE_PLATFORM)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues("OTHER"),
                                new FilterItemMap()
                                        .withField(FieldEnum.PLACEMENT)
                                        .withOperator(FilterOperatorEnum.NOT_EQUALS)
                                        .withValues("Яндекс"),
                                new FilterItemMap()
                                        .withField(FieldEnum.TARGETING_LOCATION_ID)
                                        .withOperator(FilterOperatorEnum.NOT_EQUALS)
                                        .withValues("20523"),
                                new FilterItemMap()
                                        .withField(FieldEnum.CAMPAIGN_TYPE)
                                        .withOperator(FilterOperatorEnum.IN)
                                        .withValues(CampaignTypeEnum.TEXT_CAMPAIGN.value())

                )
        )
                .withFieldNames(FieldEnum.AD_GROUP_ID, FieldEnum.AD_NETWORK_TYPE, FieldEnum.AGE, FieldEnum.AVG_CPC,
                        FieldEnum.AVG_CLICK_POSITION, FieldEnum.COST_PER_CONVERSION,
                        FieldEnum.AVG_PAGEVIEWS, FieldEnum.CAMPAIGN_ID, FieldEnum.CARRIER_TYPE, FieldEnum.CLICKS,
                        FieldEnum.CONVERSIONS, FieldEnum.CONVERSION_RATE, FieldEnum.COST,
                        FieldEnum.CRITERIA_TYPE, FieldEnum.CTR, FieldEnum.DEVICE, FieldEnum.EXTERNAL_NETWORK_NAME,
                        FieldEnum.GENDER, FieldEnum.PROFIT, FieldEnum.REVENUE, FieldEnum.AD_FORMAT,
                        FieldEnum.IMPRESSIONS, FieldEnum.LOCATION_OF_PRESENCE_ID, FieldEnum.MOBILE_PLATFORM,
                        FieldEnum.PLACEMENT, FieldEnum.TARGETING_LOCATION_ID)

                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);
        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("фильтрация по нескольким полям работает", reportsData.getTotalRows(), equalTo(TOTAL_ROWS + 1));
    }
}
