package ru.yandex.autotests.directapi.reports.filter;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 15.07.16.
 * https://st.yandex-team.ru/TESTIRT-9704
 */
@Aqua.Test
@Description("проверка работы Filter, фильтрация по AudienceTargetId")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class FilterFieldNotShowableAudienceTargetIdTest {
    private static final String CLIENT = ReportsLogins.AUDIENCE_TARGET_ID_CLIENT;
    private static final FieldEnum FILTER_FIELD = FieldEnum.AUDIENCE_TARGET_ID;
    private static final FilterOperatorEnum FILTER_OPERATOR = FilterOperatorEnum.EQUALS;
    // как это получить: найти данные с CriterionType = RETARGETING, вытащить для них CriterionId
    private static final String FILTER_VALUE = "15238275";
    private static final String DATE_FROM = "2022-03-01";
    private static final String DATE_TO = "2022-03-19";

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    public void testFilterByField() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(DATE_FROM)
                        .withDateTo(DATE_TO)
                        .withFilter(new FilterItemMap()
                                .withField(FILTER_FIELD)
                                .withOperator(FILTER_OPERATOR)
                                .withValues(FILTER_VALUE)))
                .withFieldNames(FieldEnum.DATE, FieldEnum.CRITERIA_TYPE, FieldEnum.CRITERIA_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("фильтрация по полю " + FILTER_OPERATOR + " отработала успешно", reportsData.getReportsLines(),
                not(empty()));
    }

}
