package ru.yandex.autotests.directapi.reports.filter;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 15.07.16.
 * https://st.yandex-team.ru/TESTIRT-9704
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Description("проверка работы Filter, проверка полей фильтрации, которые недоступны для вывода (только фильтрация)")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class FilterFieldNotShowableTest {
    public static final String CLIENT = ReportsLogins.CLIENT_WITH_STAT_WITH_ALL_TYPE_ADS;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter
    public FieldEnum filterField;

    @Parameterized.Parameter(1)
    public FilterOperatorEnum filterOperator;

    @Parameterized.Parameter(2)
    public String filterValue;

    @Parameterized.Parameter(3)
    public String dateFrom;

    @Parameterized.Parameter(4)
    public String dateTo;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data () {
        final String DATE_FROM = "2020-12-25";
        final String DATE_TO = "2020-12-31";
        return Arrays.asList(new Object[][]{
                {FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID, FilterOperatorEnum.EQUALS, "866883", DATE_FROM, DATE_TO},
                {FieldEnum.KEYWORD, FilterOperatorEnum.EQUALS, "купить учебник", DATE_FROM, DATE_TO},
                {FieldEnum.SMART_BANNER_FILTER_ID, FilterOperatorEnum.NOT_EQUALS, "11979", DATE_FROM, DATE_TO}
        });
    }

    @Test
    public void testFilterByField() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(dateFrom)
                        .withDateTo(dateTo)
                        .withFilter(new FilterItemMap()
                                .withField(filterField)
                                .withOperator(filterOperator)
                                .withValues(filterValue)))
                .withFieldNames(FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("фильтрация по полю " + filterOperator + " отработала успешно", reportsData.getReportsLines(),
                not(empty()));
    }

}
