package ru.yandex.autotests.directapi.reports.filter;

import java.util.Arrays;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by lightelfik on 29.08.17.
 * https://st.yandex-team.ru/DIRECT-66560
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-66560")
@Description("Filter. Проверка ограничений на количество значений для операторов, поддерживающих список")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class FilterValuesLimitTest {

    public static final String CLIENT = ReportsLogins.REPORTS_CLIENT;
    public static final int FILTER_VALUES_LIMIT = 10000;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();


    @Test
    public void checkInParametersNegative() {
        Long cids[] = new Long[FILTER_VALUES_LIMIT + 1];
        Arrays.fill(cids, 18L);
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.CAMPAIGN_ID)
                                .withOperator(FilterOperatorEnum.IN)
                                .withValues(cids)))
                .withFieldNames(FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.LAST_MONTH)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap,
                new Api5Error(4001,
                        Api5ErrorDetails.ALLOWED_TO_FILTER_IN_ONLY_10000_VALUE,
                        FieldEnum.CAMPAIGN_ID.value(),
                        FilterOperatorEnum.IN.value(),
                        10000
                ));
    }

    @Test
    public void checkInParameters() {
        Long cids[] = new Long[FILTER_VALUES_LIMIT];
        Arrays.fill(cids, 18L);
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.CAMPAIGN_ID)
                                .withOperator(FilterOperatorEnum.IN)
                                .withValues(cids)))
                .withFieldNames(FieldEnum.CAMPAIGN_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.LAST_MONTH)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("запрос отработал без ошибок", reportsData.getReportsLines().size(), equalTo(0));

    }

    @Test
    public void checkNotInParametersNegative() {
        Long cids[] = new Long[FILTER_VALUES_LIMIT + 1];
        Arrays.fill(cids, 18L);
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.AD_GROUP_ID)
                                .withOperator(FilterOperatorEnum.NOT_IN)
                                .withValues(cids)))
                .withFieldNames(FieldEnum.AD_GROUP_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.LAST_MONTH)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap,
                new Api5Error(4001,
                        Api5ErrorDetails.ALLOWED_TO_FILTER_IN_ONLY_10000_VALUE,
                        FieldEnum.AD_GROUP_ID.value(),
                        FilterOperatorEnum.NOT_IN.value(),
                        10000
                ));
    }

    @Test
    public void checkNotInParameters() {
        Long cids[] = new Long[FILTER_VALUES_LIMIT];
        Arrays.fill(cids, 18L);
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.AD_GROUP_ID)
                                .withOperator(FilterOperatorEnum.NOT_IN)
                                .withValues(cids)))
                .withFieldNames(FieldEnum.AD_GROUP_ID)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.LAST_MONTH)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("запрос отработал без ошибок", reportsData.getReportsLines().size(), equalTo(0));

    }

}
