package ru.yandex.autotests.directapi.reports.filter;

import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.*;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by onotole on 07.07.16.
 * https://st.yandex-team.ru/TESTIRT-9704
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Description("проверка работы Filter (Negative tests)")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class OperatorsNegativeTest {

    public static final String CLIENT = ReportsLogins.REPORTS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    public void checkNotInEmpty() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.AGE)
                                .withOperator(FilterOperatorEnum.NOT_IN)
                                .withValues("")))
                .withFieldNames(FieldEnum.AGE)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.ALL_TIME)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                reportDefinitionMap,
                new Api5Error(4001, Api5ErrorDetails.ALLOWED_TO_FILTER_ONLY_AGES));
    }

    @Test
    public void checkNotEqualsEmpty() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.AGE)
                                .withOperator(FilterOperatorEnum.NOT_EQUALS)
                                .withValues("")))
                .withFieldNames(FieldEnum.AGE)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.ALL_TIME)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                reportDefinitionMap,
                new Api5Error(4001, Api5ErrorDetails.ALLOWED_TO_FILTER_ONLY_AGES));
    }

    @Test
    public void checkIntNotEqualsDouble() {
        FieldEnum fieldEnum = FieldEnum.AD_GROUP_ID;
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(fieldEnum)
                                .withOperator(FilterOperatorEnum.NOT_EQUALS)
                                .withValues("13.13")))
                .withFieldNames(fieldEnum)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.ALL_TIME)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap,
                new Api5Error(4001, Api5ErrorDetails.INCORRECT_IDENTIFICATOR_FOR_FILTER, fieldEnum.value()));
    }

    @Test
    public void checkInvalidParameter() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.AGE)
                                .withOperator(FilterOperatorEnum.EQUALS)
                                .withValues("AGE_25_26")))
                .withFieldNames(FieldEnum.AGE)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.ALL_TIME)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(
                reportDefinitionMap,
                new Api5Error(4001, Api5ErrorDetails.ALLOWED_TO_FILTER_ONLY_AGES));
    }

    @Test
    public void checkEqual2Parameters() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.AGE)
                                .withOperator(FilterOperatorEnum.EQUALS)
                                .withValues(AgeRangeEnum.AGE_0_17.value(), AgeRangeEnum.AGE_18_24.value())))
                .withFieldNames(FieldEnum.AGE)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.ALL_TIME)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap,
                new Api5Error(4001,
                        Api5ErrorDetails.ALLOWED_TO_FILTER_EQUALS_ONLY_ONE_VALUE,
                        FieldEnum.AGE.value(),
                        FilterOperatorEnum.EQUALS.value()));
    }

    @Test
    public void checkIncorrectValueForLessThan() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.AVG_CLICK_POSITION)
                                .withOperator(FilterOperatorEnum.LESS_THAN)
                                .withValues("str")))
                .withFieldNames(FieldEnum.AVG_CLICK_POSITION)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.ALL_TIME)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap,
                new Api5Error(4001, Api5ErrorDetails.INCORRECT_VALUE_FOR_FILTER, FieldEnum.AVG_CLICK_POSITION.value()));
    }

    @Test
    public void checkAge45Error() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom("2019-02-28")
                        .withDateTo("2019-03-28")
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.AGE)
                                .withOperator(FilterOperatorEnum.EQUALS)
                                .withValues(AgeRangeEnum.AGE_45.value())))
                .withFieldNames(FieldEnum.AGE)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap,
                new Api5Error(4001,
                        Api5ErrorDetails.INCORRECT_VALUE_FOR_FILTER_AGE_45));
    }

}
