package ru.yandex.autotests.directapi.reports.filter;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 07.07.16.
 * https://st.yandex-team.ru/TESTIRT-9704
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Description("проверка работы Filter")
@RunWith(Parameterized.class)
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class OperatorsTest {
    public static final String CLIENT = ReportsLogins.CLIENT_EUR_WITH_STAT;
    private static final String DATE_FROM = "2021-02-28";
    private static final String DATE_TO = "2021-03-28";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FilterItemMap filterItemMap;

    @Parameterized.Parameter(1)
    public int expectedRowsCount;

    @Parameterized.Parameter(2)
    public FieldEnum fieldName;

    @Parameterized.Parameters(name = "{2}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][] {
                {new FilterItemMap()
                        .withField(FieldEnum.CAMPAIGN_ID)
                        .withOperator(FilterOperatorEnum.EQUALS)
                        .withValues(30435648), 1, FieldEnum.CAMPAIGN_ID},
                {new FilterItemMap()
                        .withField(FieldEnum.CAMPAIGN_ID)
                        .withOperator(FilterOperatorEnum.IN)
                        .withValues(30298803, 29622292), 2, FieldEnum.CAMPAIGN_ID},
                {new FilterItemMap()
                        .withField(FieldEnum.CTR)
                        .withOperator(FilterOperatorEnum.GREATER_THAN)
                        .withValues("15.5"), 31, FieldEnum.CAMPAIGN_ID},
                {new FilterItemMap()
                        .withField(FieldEnum.CTR)
                        .withOperator(FilterOperatorEnum.LESS_THAN)
                        .withValues("3.13"), 209, FieldEnum.CAMPAIGN_ID},
                {new FilterItemMap()
                        .withField(FieldEnum.KEYWORD)
                        .withOperator(FilterOperatorEnum.STARTS_WITH_IGNORE_CASE)
                        .withValues("гостиницы"), 165, FieldEnum.CAMPAIGN_ID},
                {new FilterItemMap()
                        .withField(FieldEnum.KEYWORD)
                        .withOperator(FilterOperatorEnum.STARTS_WITH_ANY_IGNORE_CASE)
                        .withValues("RandomText", "гостиницы"), 165, FieldEnum.CAMPAIGN_ID},
                {new FilterItemMap()
                        .withField(FieldEnum.KEYWORD)
                        .withOperator(FilterOperatorEnum.DOES_NOT_START_WITH_IGNORE_CASE)
                        .withValues("гостиницы"), 411, FieldEnum.CAMPAIGN_ID},
                {new FilterItemMap()
                        .withField(FieldEnum.KEYWORD)
                        .withOperator(FilterOperatorEnum.DOES_NOT_START_WITH_ALL_IGNORE_CASE)
                        .withValues("гусеничные транспортеры", "гостиницы"), 411, FieldEnum.CAMPAIGN_ID},
                {new FilterItemMap()
                        .withField(FieldEnum.MATCH_TYPE)
                        .withOperator(FilterOperatorEnum.EQUALS)
                        .withValues("SYNONYM"), 1, FieldEnum.MATCH_TYPE},
                {new FilterItemMap()
                        .withField(FieldEnum.AGE)
                        .withOperator(FilterOperatorEnum.NOT_EQUALS)
                        .withValues(AgeRangeEnum.AGE_25_34.value()),
                        AgeRangeEnum.values().length-1, FieldEnum.AGE},
                {new FilterItemMap()
                        .withField(FieldEnum.AGE)
                        .withOperator(FilterOperatorEnum.NOT_IN)
                        .withValues(AgeRangeEnum.AGE_25_34.value(), AgeRangeEnum.AGE_0_17.value()),
                        AgeRangeEnum.values().length - 2, FieldEnum.AGE},
                {new FilterItemMap()
                        .withField(FieldEnum.AGE)
                        .withOperator(FilterOperatorEnum.EQUALS)
                        .withValues(AgeRangeEnum.AGE_45_54.value()),
                        1, FieldEnum.AGE}
        });
    }

    @Test
    public void checkEqualForDouble() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(DATE_FROM)
                        .withDateTo(DATE_TO)
                        .withFilter(filterItemMap))
                .withFieldNames(fieldName)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("фильтрация по " + filterItemMap + " отработала", reportsData.getReportsLines().size(), equalTo(expectedRowsCount));
    }

}
