package ru.yandex.autotests.directapi.reports.filter;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 18.07.16.
 * https://st.yandex-team.ru/TESTIRT-9704
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Description("проверка работы Filter, проверка полей для фильтрации, по которым нет данных для клиента из AllFilterFieldsTest")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class SpecialFilterFieldsTest {

    public static final String CLIENT = ReportsLogins.CLIENT_RUB_WITH_STAT2;
    private final static String TOTAL_ROWS = "Total rows: ";
    // при группировке по одному, числому полю в отчете всегда одна строка
    private final static String ROW_COUNT = "1";
    private final static String DATE_FROM = "2019-08-01";
    private final static String DATE_TO = "2019-09-01";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FieldEnum filterField;

    @Parameterized.Parameter(1)
    public FilterOperatorEnum filterOperator;

    @Parameterized.Parameter(2)
    public String filterValue;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data () {
        return Arrays.asList(new Object[][]{
                {FieldEnum.GOALS_ROI, FilterOperatorEnum.LESS_THAN, "1"},
                {FieldEnum.REVENUE, FilterOperatorEnum.GREATER_THAN, "1"},
        });
    }

    @Test
    public void testFilterByField() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(DATE_FROM)
                        .withDateTo(DATE_TO)
                        .withFilter(new FilterItemMap()
                                .withField(filterField)
                                .withOperator(filterOperator)
                                .withValues(filterValue)))
                .withFieldNames(filterField)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("фильтрация по полю " + filterOperator + " отработала успешно", reportsData.getTotalRows(),
                equalTo(TOTAL_ROWS + ROW_COUNT));
    }

}
