package ru.yandex.autotests.directapi.reports.multigoals;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.general.AttributionModelEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by lightelfik on 30.03.18.
 * https://st.yandex-team.ru/DIRECT-59898
 */
@Aqua.Test
@Description("Проверка корректной работы репортов для нескольких целей")
@Issue("https://st.yandex-team.ru/DIRECT-59898")
@Features(ReportsFeatures.OFFLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class MultiGoalsValidationTest {

    private final static Long CAMPAIGN_ID = 6922642L;
    private final static int GOALS_LIMIT = 10;
    private final static String DATE_FROM = "2020-10-01";
    private final static String DATE_TO = "2020-11-19";
    private final static List<Long> COMPLEX_GOAL_PARAMS = Arrays.asList(
            -1L,2499000010L,4000000000L, 4000000001L,3999999999L,-2L);
    private final static String COMPLEX_GOAL_PARAMS_ERROR = "-1, 4000000001, -2";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_RUB_WITH_STAT2);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public List<Long> goalIds;

    @Parameterized.Parameter(1)
    public List<AttributionModelEnum> attributionModels;

    @Parameterized.Parameter(2)
    public Api5Error error;

    @Parameterized.Parameters(name = "{0} {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Arrays.asList(0L), Arrays.asList(),
                        new Api5Error(4000, Api5ErrorDetails.BAD_FIELD_PARAMS,
                                capitalize(ReportDefinitionMap.GOALS), 0L)},
                {Arrays.asList(-1L), Arrays.asList(),
                        new Api5Error(4000, Api5ErrorDetails.BAD_FIELD_PARAMS,
                                capitalize(ReportDefinitionMap.GOALS), -1L)},
                {COMPLEX_GOAL_PARAMS, Arrays.asList(),
                        new Api5Error(4000, Api5ErrorDetails.BAD_FIELD_PARAMS,
                                capitalize(ReportDefinitionMap.GOALS), COMPLEX_GOAL_PARAMS_ERROR)},
                {Arrays.asList(1L, 1L), Arrays.asList(),
                        new Api5Error(9802, Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                1, capitalize(ReportDefinitionMap.GOALS))},
                {Arrays.asList(1L), Arrays.asList(AttributionModelEnum.LC, AttributionModelEnum.LC),
                        new Api5Error(9802, Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                AttributionModelEnum.LC.value(), capitalize(ReportDefinitionMap.ATTRIBUTION_MODELS))},
                {Arrays.asList(), Arrays.asList(AttributionModelEnum.LC),
                        new Api5Error(4000, Api5ErrorDetails.FIELD_NEED_DEFINED_OTHER_FIELD,
                                capitalize(ReportDefinitionMap.ATTRIBUTION_MODELS),
                                capitalize(ReportDefinitionMap.GOALS))},
                {Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L), Arrays.asList(AttributionModelEnum.LC),
                        new Api5Error(7000, Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                                capitalize(ReportDefinitionMap.GOALS), GOALS_LIMIT)},
        });
    }

    @Test
    public void checkReportWithOneGoal() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withCustomDatesAndCampaignIds(DATE_FROM, DATE_TO, CAMPAIGN_ID)
                .withGoals(goalIds.toArray(new Long[0]))
                .withAttributionModels(attributionModels.toArray(new AttributionModelEnum[0]))
                .withFieldNames(FieldEnum.CAMPAIGN_ID, FieldEnum.CONVERSIONS);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap, error);
    }

}
