package ru.yandex.autotests.directapi.reports.orderby;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsLine;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 9/28/16.
 * https://st.yandex-team.ru/TESTIRT-9722
 */
@Aqua.Test
@Description("Проверка порядка дат в отчете")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class CheckDateOrderTest {
    private static final String CLIENT = ReportsLogins.CLIENT_FOR_DATE_ORDER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String dateTo;

    @Parameterized.Parameter(1)
    public String dateFrom;

    @Parameterized.Parameter(2)
    public FieldEnum fieldPeriodType;

    @Parameterized.Parameter(3)
    public int expectedCountOfPeriods;

    @Parameterized.Parameters(name = "{0} {1} {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][] {
                {"2020-09-08", "2019-03-08", FieldEnum.YEAR, 2},
                {"2020-09-08", "2019-09-08", FieldEnum.QUARTER, 4},
                {"2020-08-08", "2019-09-08", FieldEnum.MONTH, 8},
                {"2020-08-08", "2019-09-08", FieldEnum.WEEK, 20},
                {"2020-08-08", "2019-09-08", FieldEnum.DATE, 95},

                {"2019-09-08", "2019-03-08", FieldEnum.YEAR, 1},
                {"2019-09-08", "2019-07-08", FieldEnum.QUARTER, 1},
                {"2019-09-08", "2019-09-01", FieldEnum.MONTH, 1},
                {"2019-09-08", "2019-09-05", FieldEnum.WEEK, 1},
                {"2019-09-08", "2019-09-08", FieldEnum.DATE, 1},
        });
    }

    @Test
    public void checkDateOrder() {
        String currentDate;
        String previousDate;
        Boolean isOrderCorrect = true;

        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withFieldNames(fieldPeriodType)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.YES)
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateFrom(dateFrom)
                        .withDateTo(dateTo))
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assumeThat("вернулось нужно количество строк в репорте", reportsData.getReportsLines().size(), equalTo(expectedCountOfPeriods));

        previousDate = getDate(reportsData.getReportsLines().get(0));
        for (int i = 1; i < reportsData.getReportsLines().size(); i++) {
            currentDate = getDate(reportsData.getReportsLines().get(i));

            // на нарушен ли порядок
            if (currentDate.compareTo(previousDate) < 0 ) {
                isOrderCorrect = false;
            }
            previousDate = currentDate;
        }
        assertThat("Даты из репорта шли в нужном порядке", isOrderCorrect, equalTo(true));

    }

    private String getDate(ReportsLine reportsLine) {
        String result = "";
        switch(fieldPeriodType) {
            case DATE:
                result = reportsLine.getDate();
                break;
            case YEAR:
                result = reportsLine.getYear();
                break;
            case QUARTER:
                result = reportsLine.getQuarter();
                break;
            case MONTH:
                result = reportsLine.getMonth();
                break;
            case WEEK:
                result = reportsLine.getWeek();
                break;
        }
        return result;
    }
}
